<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_cicool extends CI_Migration {

        public function up()
        {
                //create table groups
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '100',
                                'null' => TRUE,
                        ),
                        'definition' => array(
                                'type' => 'TEXT',
                                'null' => TRUE,
                        ),
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('aauth_groups');

                //create table group to group
                $this->dbforge->add_field(array(
                        'group_id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                        ),
                        'subgroup_id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                        )
                ));
                $this->dbforge->add_key('group_id', TRUE);
                $this->dbforge->add_key('subgroup_id', TRUE);
                $this->dbforge->create_table('aauth_group_to_group');


                //create table group to group
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'ip_address' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 39,
                                'null' => TRUE,
                        ),
                        'timestamp' => array(
                                'type' => 'DATETIME',
                                'null' => TRUE,
                        ),
                        'login_attempts' => array(
                                'type' => 'TINYINT',
                                'constraint' => 2,
                                'null' => TRUE,
                                'unsigned' => TRUE,
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('aauth_login_attempts');

                 //create table perms
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 100,
                                'unsigned' => TRUE,
                                'null' => TRUE
                        ),
                        'definition' => array(
                                'type' => 'TEXT',
                                'null' => TRUE
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('aauth_perms');


                //create table perm_to_group
                $this->dbforge->add_field(array(
                        'perm_id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                        ),
                        'group_id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                        )
                ));
                $this->dbforge->create_table('aauth_perm_to_group');

                //create table cc_session
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                        ),
                        'ip_address' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 45,
                        ),
                        'timestamp' => array(
                                'type' => 'INT',
                                'constraint' => 10,
                        ),
                        'data' => array(
                                'type' => 'BLOB',
                        )
                ));
                $this->dbforge->create_table('cc_session');
                $this->dbforge->add_key('id', TRUE);

                //create table perm_to_user
                $this->dbforge->add_field(array(
                        'perm_id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                        ),
                        'user_id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                        )
                ));
                $this->dbforge->add_key('user_id', TRUE);
                $this->dbforge->add_key('perm_id', TRUE);
                $this->dbforge->create_table('aauth_perm_to_user');


                //create table pms
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'index' => TRUE,
                                'auto_increment' => TRUE,
                                'unsigned' => TRUE,
                        ),
                        'sender_id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'index' => TRUE,
                                'unsigned' => TRUE,
                        ),
                        'receiver_id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'index' => TRUE,
                                'unsigned' => TRUE,
                        ),
                        'title' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 225,
                        ),
                        'message' => array(
                                'type' => 'TEXT',
                                'null' => TRUE,
                        ),
                        'date_sent' => array(
                                'type' => 'DATETIME',
                                'null' => TRUE,
                        ),
                        'date_read' => array(
                                'type' => 'DATETIME',
                                'null' => TRUE,
                                'index' => TRUE
                        ),
                        'pm_deleted_sender' => array(
                                'type' => 'INT',
                                'constraint' => 1,
                                'null' => TRUE,
                        ),
                        'pm_deleted_receiver' => array(
                                'type' => 'INT',
                                'constraint' => 1,
                                'null' => TRUE,
                        ),
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('aauth_pms');


                //create table user
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 100,
                                'null' => TRUE
                        ),
                        'definition' => array(
                                'type' => 'TEXT',
                                'null' => TRUE,
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('aauth_user');


                 //create table users
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'email' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 100,
                        ),
                        'pass' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 64,
                        ),
                        'username' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 100,
                        ),
                        'full_name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 200,
                        ),
                        'avatar' => array(
                                'type' => 'TEXT',
                        ),
                        'banned' => array(
                                'type' => 'TINYINT',
                                'constraint' => 1,
                                'null' => TRUE,
                                'default' => 0
                        ),
                        'last_login' => array(
                                'type' => 'DATETIME',
                                'null' => TRUE,
                        ),
                        'last_activity' => array(
                                'type' => 'DATETIME',
                                'null' => TRUE,
                        ),
                        'date_created' => array(
                                'type' => 'DATETIME',
                                'null' => TRUE,
                        ),
                        'forgot_exp' => array(
                                'type' => 'TEXT',
                                'null' => TRUE,
                        ),
                        'remember_time' => array(
                                'type' => 'DATETIME',
                                'null' => TRUE,
                        ),
                        'remember_exp' => array(
                                'type' => 'TEXT',
                                'null' => TRUE,
                        ),
                        'verification_code' => array(
                                'type' => 'TEXT',
                                'null' => TRUE,
                        ),
                        'top_secret' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 16,
                                'null' => TRUE,
                        ),
                        'ip_address' => array(
                                'type' => 'TEXT',
                                'null' => TRUE,
                        ),
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('aauth_users');


                //create table user_to_group
                $this->dbforge->add_field(array(
                        'user_id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                        ),  
                        'group_id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                        ),
                ));
                $this->dbforge->add_key('user_id', TRUE);
                $this->dbforge->add_key('group_id', TRUE);
                $this->dbforge->create_table('aauth_user_to_group');



                //create table user_to_group
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),  
                        'user_id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'index' => TRUE
                        ),
                        'data_key' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 100,
                        ),
                        'value' => array(
                                'type' => 'TEXT',
                                'null' => TRUE,
                        ),
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('aauth_user_variables');

                //create table blog
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),  
                        'title' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 200,
                        ),
                        'content' => array(
                                'type' => 'TEXT',
                        ), 
                        'image' => array(
                                'type' => 'TEXT',
                        ),
                        'category' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 200,
                        ),
                        'created_at' => array(
                                'type' => 'DATETIME',
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('blog');

                 //create table blog
                $this->dbforge->add_field(array(
                        'category_id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),  
                        'category_name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 200,
                        ),
                        'category_desc' => array(
                                'type' => 'TEXT',
                        )
                ));
                $this->dbforge->add_key('category_id', TRUE);
                $this->dbforge->create_table('blog_category');

                //create table menu
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'label' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                                'null' => TRUE,
                        ),
                        'type' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                                'null' => TRUE,
                        ),
                        'icon_color' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                                'null' => TRUE,
                        ),
                        'link' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                                'null' => TRUE,
                        ),
                        'sort' => array(
                                'type' => 'INT',
                        ),
                        'parent' => array(
                                'type' => 'INT',
                        ),
                        'icon' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '50',
                                'null' => TRUE,
                        ),
                        'menu_type_id' => array(
                                'type' => 'INT',
                        ),
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('menu');

                //create table menu type
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'definition' => array(
                                'type' => 'TEXT',
                                'null' => TRUE,
                        ),
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('menu_type');

                //create table icon menu
                $this->dbforge->add_field(array(
                        'class_name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        )
                ));
                $this->dbforge->create_table('menu_icon');

                //insert dummy data
                $this->db->insert_batch('aauth_groups', [
                    [
                        'name' => 'Admin',
                        'definition' => 'Superadmin Group'
                    ],   
                    [
                        'name' => 'Public',
                        'definition' => 'Public Group'
                    ], 
                    [
                        'name' => 'Default',
                        'definition' => 'Default Access Group'
                    ],
                    [
                        'name' => 'Member',
                        'definition' => 'Member Access Group'
                    ],
                ]);

                //create table crud
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'title' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'subject' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'table_name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'primary_key' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'page_read' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '20',
                                'null' => TRUE,
                        ),
                        'page_create' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '20',
                                'null' => TRUE,
                        ),
                        'page_update' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '20',
                                'null' => TRUE,
                        ),
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('crud');

                //create table form
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'title' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'subject' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'table_name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('form');


                //create table rest
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'subject' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'table_name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'primary_key' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'x_api_key' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '20',
                                'null' => TRUE,
                        ),
                        'x_token' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '20',
                                'null' => TRUE,
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('rest');


                $this->db->insert_batch('aauth_user_to_group', [
                    [
                        'user_id' => 1,
                        'group_id' => 1
                    ]
                ]);


                //create table crud input type
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'type' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'relation' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '20',
                        ),
                        'custom_value' => array(
                                'type' => 'INT',
                        ),
                        'validation_group' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('crud_input_type');

                //create table rest input type
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'type' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'relation' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '20',
                        ),
                        'validation_group' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('rest_input_type');

                //create table crud field validation
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'crud_field_id' => array(
                                'type' => 'INT',
                        ),
                        'crud_id' => array(
                                'type' => 'INT',
                        ),
                        'validation_name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'validation_value' => array(
                                'type' => 'TEXT',
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('crud_field_validation');


                //create table rest field validation
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'rest_field_id' => array(
                                'type' => 'INT',
                        ),
                        'rest_id' => array(
                                'type' => 'INT',
                        ),
                        'validation_name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'validation_value' => array(
                                'type' => 'TEXT',
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('rest_field_validation');


                //create table crud input type
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'crud_id' => array(
                                'type' => 'INT',
                        ),
                        'field_name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'input_type' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'show_column' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '10',
                                'null' => true
                        ),
                        'show_add_form' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '10',
                                'null' => true
                        ),
                        'show_update_form' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '10',
                                'null' => true
                        ),
                        'show_detail_page' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '10',
                                'null' => true
                        ),
                        'sort' => array(
                                'type' => 'INT',
                        ),
                        'relation_table' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                                'null' => true
                        ),
                        'relation_value' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                                'null' => true
                        ),
                        'relation_label' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                                'null' => true
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('crud_field');

                //create table rest field
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'rest_id' => array(
                                'type' => 'INT',
                        ),
                        'field_name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'input_type' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'show_column' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '10',
                                'null' => true
                        ),
                        'show_add_api' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '10',
                                'null' => true
                        ),
                        'show_update_api' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '10',
                                'null' => true
                        ),
                        'show_detail_api' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '10',
                                'null' => true
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('rest_field');


                $this->db->insert_batch('crud_input_type', [
                    [
                        'type'      => 'input',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'input'
                    ],
                    [
                        'type'      => 'textarea',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'text'
                    ],
                    [
                        'type'      => 'select',
                        'relation'  => 1,
                        'custom_value' => 0,
                        'validation_group' => 'select'
                    ],
                    [
                        'type'      => 'editor_wysiwyg',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'editor'
                    ],
                    [
                        'type'      => 'password',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'password'
                    ],
                    [
                        'type'      => 'email',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'email'
                    ],
                    [
                        'type'      => 'address_map',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'address_map'
                    ],
                    [
                        'type'      => 'file',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'file'
                    ],
                    [
                        'type'      => 'file_multiple',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'file_multiple'
                    ],
                    [
                        'type'      => 'datetime',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'datetime'
                    ],
                    [
                        'type'      => 'date',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'date'
                    ],
                    [
                        'type'      => 'timestamp',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'timestamp'
                    ],
                    [
                        'type'      => 'number',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'number'
                    ],
                    [
                        'type'      => 'yes_no',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'yes_no'
                    ],
                    [
                        'type'      => 'time',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'time'
                    ],
                    [
                        'type'      => 'year',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'year'
                    ],
                    [
                        'type'      => 'select_multiple',
                        'relation'  => 1,
                        'custom_value' => 0,
                        'validation_group' => 'select_multiple'
                    ],
                    [
                        'type'      => 'checkboxes',
                        'relation'  => 1,
                        'custom_value' => 0,
                        'validation_group' => 'checkboxes'
                    ],
                    [
                        'type'      => 'options',
                        'relation'  => 1,
                        'custom_value' => 0,
                        'validation_group' => 'options'
                    ],
                    [
                        'type'      => 'true_false',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'true_false'
                    ],
                    [
                        'type'      => 'current_user_username',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'user_username'
                    ],
                    [
                        'type'      => 'current_user_id',
                        'relation'  => 0,
                        'custom_value' => 0,
                        'validation_group' => 'current_user_id'
                    ],
                    [
                        'type'      => 'custom_option',
                        'relation'  => 0,
                        'custom_value' => 1,
                        'validation_group' => 'custom_option'
                    ],
                    [
                        'type'      => 'custom_checkbox',
                        'relation'  => 0,
                        'custom_value' => 1,
                        'validation_group' => 'custom_checkbox'
                    ],
                    [
                        'type'      => 'custom_select_multiple',
                        'relation'  => 0,
                        'custom_value' => 1,
                        'validation_group' => 'custom_select_multiple'
                    ],
                    [
                        'type'      => 'custom_select',
                        'relation'  => 0,
                        'custom_value' => 1,
                        'validation_group' => 'custom_select'
                    ],
                ]);


                $this->db->insert_batch('rest_input_type', [
                    [
                        'type'      => 'input',
                        'relation'  => 0,
                        'validation_group' => 'input'
                    ], 
                    [
                        'type'      => 'timestamp',
                        'relation'  => 0,
                        'validation_group' => 'timestamp'
                    ],
                    [
                        'type'      => 'file',
                        'relation'  => 0,
                        'validation_group' => 'file'
                    ]
                ]);

                 //create table captcha
                $this->dbforge->add_field(array(
                        'captcha_id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'captcha_time' => array(
                                'type' => 'INT',
                                'constraint' => '10',
                                'null' => true
                        ),
                        'ip_address' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '45',
                        ),
                        'word' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '20',
                        ),
                ));
                $this->dbforge->add_key('captcha_id', TRUE);
                $this->dbforge->create_table('captcha');

                 //create table form field
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'form_id' => array(
                                'type' => 'INT',
                        ),
                        'sort' => array(
                                'type' => 'INT',
                        ),
                        'field_name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'input_type' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'field_label' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                                'null' => true
                        ),
                        'placeholder' => array(
                                'type' => 'TEXT',
                                'null' => true
                        ),
                        'auto_generate_help_block' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '10',
                                'null' => true
                        ),
                        'help_block' => array(
                                'type' => 'TEXT',
                                'null' => true
                        ),
                        'relation_table' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                                'null' => true
                        ),
                        'relation_value' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                                'null' => true
                        ),
                        'relation_label' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                                'null' => true
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('form_field');


                //create table page
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'title' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'type' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'content' => array(
                                'type' => 'TEXT',
                        ),
                        'fresh_content' => array(
                                'type' => 'TEXT',
                        ),
                        'keyword' => array(
                                'type' => 'TEXT',
                                'null' => TRUE,
                        ),
                        'description' => array(
                                'type' => 'TEXT',
                                'null' => TRUE,
                        ),
                        'link' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                                'null' => TRUE,
                        ),
                        'template' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                                'null' => TRUE,
                        ),
                        'created_at' => array(
                                'type' => 'TIMESTAMP',
                        ),
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('page');

                //create table form field validation
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'form_field_id' => array(
                                'type' => 'INT',
                        ),
                        'form_id' => array(
                                'type' => 'INT',
                        ),
                        'validation_name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'validation_value' => array(
                                'type' => 'TEXT',
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('form_field_validation');


                //create table cc options
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'option_name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'option_value' => array(
                                'type' => 'TEXT',
                                'null' => true
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('cc_options');  

                //add option 
                add_option('active_theme', 'cicool');
                add_option('favicon', 'default.png');

                //create table page block element
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'group_name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 200
                        ),
                        'content' => array(
                                'type' => 'TEXT',
                        ),
                        'image_preview' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'block_name' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'content_type' => array(
                                 'type' => 'VARCHAR',
                                'constraint' => '100',
                        )
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('page_block_element');

                //create table crud custom attribute
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'form_field_id' => array(
                                'type' => 'INT',
                        ),
                        'form_id' => array(
                                'type' => 'INT',
                        ),
                        'attribute_value' => array(
                                'type' => 'TEXT',
                        ),
                        'attribute_label' => array(
                                'type' => 'TEXT',
                        ),
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('form_custom_attribute');

                //create table form custom value
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'form_field_id' => array(
                                'type' => 'INT',
                        ),
                        'form_id' => array(
                                'type' => 'INT',
                        ),
                        'option_value' => array(
                                'type' => 'TEXT',
                        ),
                        'option_label' => array(
                                'type' => 'TEXT',
                        ),
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('form_custom_option');



                //create table crud input validation
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'validation' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '200',
                        ),
                        'input_able' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '20',
                        ),
                        'group_input' => array(
                                'type' => 'TEXT',
                        ),
                        'input_placeholder' => array(
                                'type' => 'TEXT',
                        ),
                        'call_back' => array(
                                'type' => 'VARCHAR',
                                'constraint' => '10',
                        ),
                        'input_validation' => array(
                                'type' => 'TEXT',
                        ),
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('crud_input_validation');


                $this->db->insert_batch('crud_input_validation', [
                     [ 
                        'validation' => 'required', 
                        'input_able' => 'no', 
                        'group_input' => 'input, file, number, text, datetime, select, password, email, editor, date, yes_no, time, year, select_multiple, options, checkboxes, true_false, address_map, custom_option, custom_checkbox, custom_select_multiple, custom_select, file_multiple',
                        'input_placeholder' => '',
                        'call_back' => '',
                        'input_validation' => ''

                     ],
                     [ 
                        'validation' => 'max_length', 
                        'input_able' => 'yes', 
                        'group_input' => 'input, number, text, select, password, email, editor, yes_no, time, year, select_multiple, options, checkboxes, address_map',
                        'input_placeholder' => '',
                        'call_back' => '',
                        'input_validation' => 'numeric'
                     ],
                     [ 
                        'validation' => 'min_length', 
                        'input_able' => 'yes', 
                        'group_input' => 'input, number, text, select, password, email, editor, time, year, select_multiple, address_map',
                        'input_placeholder' => '',
                        'call_back' => '',
                        'input_validation' => 'numeric'

                     ],
                     [ 
                        'validation' => 'valid_email', 
                        'input_able' => 'no', 
                        'group_input' => 'input, email',
                        'input_placeholder' => '',
                        'call_back' => '',
                        'input_validation' => ''

                     ],
                     [ 
                        'validation' => 'valid_emails', 
                        'input_able' => 'no', 
                        'group_input' => 'input, email',
                        'input_placeholder' => '',
                        'call_back' => '',
                        'input_validation' => ''

                     ],
                     [ 
                        'validation' => 'regex', 
                        'input_able' => 'yes', 
                        'group_input' => 'input, number, text, datetime, select, password, email, editor, date, yes_no, time, year, select_multiple, options, checkboxes',
                        'input_placeholder' => '',
                        'call_back' => 'yes',
                        'input_validation' => 'callback_valid_regex'

                     ],
                     [ 
                        'validation' => 'decimal', 
                        'input_able' => 'no', 
                        'group_input' => 'input, number, text, select',
                        'input_placeholder' => '',
                        'call_back' => '',
                        'input_validation' => ''

                     ],
                     [ 
                        'validation' => 'allowed_extension', 
                        'input_able' => 'yes', 
                        'group_input' => 'file, file_multiple',
                        'input_placeholder' => 'ex : jpg,png,..',
                        'call_back' => '',
                        'input_validation' => 'callback_valid_extension_list'

                     ],
                     [ 
                        'validation' => 'max_width', 
                        'input_able' => 'yes', 
                        'group_input' => 'file, file_multiple',
                        'input_placeholder' => '',
                        'call_back' => '',
                        'input_validation' => 'numeric'

                     ],
                     [ 
                        'validation' => 'max_height', 
                        'input_able' => 'yes', 
                        'group_input' => 'file, file_multiple',
                        'input_placeholder' => '',
                        'call_back' => '',
                        'input_validation' => 'numeric'

                     ],
                     [ 
                        'validation' => 'max_size', 
                        'input_able' => 'yes', 
                        'group_input' => 'file, file_multiple',
                        'input_placeholder' => '... kb',
                        'call_back' => '',
                        'input_validation' => 'numeric'

                     ],
                     [ 
                        'validation' => 'max_item', 
                        'input_able' => 'yes', 
                        'group_input' => 'file_multiple',
                        'input_placeholder' => '',
                        'call_back' => '',
                        'input_validation' => 'numeric'

                     ],
                     [ 
                        'validation' => 'valid_url', 
                        'input_able' => 'no', 
                        'group_input' => 'input, text',
                        'input_placeholder' => '',
                        'call_back' => '',
                        'input_validation' => ''

                     ],
                     [ 
                        'validation' => 'alpha', 
                        'input_able' => 'no', 
                        'group_input' => 'input, text, select, password, editor, yes_no',
                        'input_placeholder' => '',
                        'call_back' => '',
                        'input_validation' => ''

                     ],
                     [ 
                        'validation' => 'alpha_numeric', 
                        'input_able' => 'no', 
                        'group_input' => 'input, number, text, select, password, editor',
                        'input_placeholder' => '',
                        'call_back' => '',
                        'input_validation' => ''

                     ],
                     [ 
                        'validation' => 'alpha_numeric_spaces', 
                        'input_able' => 'no', 
                        'group_input' => 'input, number, text,select, password, editor',
                        'input_placeholder' => '',
                        'call_back' => '',
                        'input_validation' => ''

                     ],
                     [ 
                        'validation' => 'valid_number', 
                        'input_able' => 'no', 
                        'group_input' => 'input, number, text, password, editor, true_false',
                        'input_placeholder' => '',
                        'call_back' => 'yes',
                        'input_validation' => ''

                     ],
                     [ 
                        'validation' => 'valid_datetime', 
                        'input_able' => 'no', 
                        'group_input' => 'input, datetime, text',
                        'input_placeholder' => '',
                        'call_back' => 'yes',
                        'input_validation' => ''

                     ],
                     [ 
                        'validation' => 'valid_date', 
                        'input_able' => 'no', 
                        'group_input' => 'input, datetime, date, text',
                        'input_placeholder' => '',
                        'call_back' => 'yes',
                        'input_validation' => ''

                     ],
                     [ 
                        'validation' => 'valid_max_selected_option', 
                        'input_able' => 'yes', 
                        'group_input' => 'select_multiple, custom_select_multiple, custom_checkbox, checkboxes',
                        'input_placeholder' => '',
                        'call_back' => 'yes',
                        'input_validation' => 'numeric'
                     ],
                     [ 
                        'validation' => 'valid_min_selected_option', 
                        'input_able' => 'yes', 
                        'group_input' => 'select_multiple, custom_select_multiple, custom_checkbox, checkboxes',
                        'input_placeholder' => '',
                        'call_back' => 'yes',
                        'input_validation' => 'numeric'
                     ],
                     [ 
                        'validation' => 'valid_alpha_numeric_spaces_underscores', 
                        'input_able' => 'no', 
                        'group_input' => 'input, text,select, password, editor',
                        'input_placeholder' => '',
                        'call_back' => 'yes',
                        'input_validation' => ''
                     ],
                     [ 
                        'validation' => 'matches', 
                        'input_able' => 'yes', 
                        'group_input' => 'input, number, text, password, email',
                        'input_placeholder' => 'any field',
                        'call_back' => 'no',
                        'input_validation' => 'callback_valid_alpha_numeric_spaces_underscores'
                     ],
                     [ 
                        'validation' => 'valid_json', 
                        'input_able' => 'no', 
                        'group_input' => 'input, text, editor',
                        'input_placeholder' => '',
                        'call_back' => 'yes',
                        'input_validation' => ' '
                     ],
                     [ 
                        'validation' => 'valid_url', 
                        'input_able' => 'no', 
                        'group_input' => 'input, text, editor',
                        'input_placeholder' => '',
                        'call_back' => 'no',
                        'input_validation' => ' '
                     ],
                     [ 
                        'validation' => 'exact_length', 
                        'input_able' => 'yes', 
                        'group_input' => 'input, text, number',
                        'input_placeholder' => '0 - 99999*',
                        'call_back' => 'no',
                        'input_validation' => 'numeric'
                     ],
                     [ 
                        'validation' => 'alpha_dash', 
                        'input_able' => 'no', 
                        'group_input' => 'input, text',
                        'input_placeholder' => '',
                        'call_back' => 'no',
                        'input_validation' => ''
                     ],
                     [ 
                        'validation' => 'integer', 
                        'input_able' => 'no', 
                        'group_input' => 'input, text, number',
                        'input_placeholder' => '',
                        'call_back' => 'no',
                        'input_validation' => ''
                     ],
                     [ 
                        'validation' => 'differs', 
                        'input_able' => 'yes', 
                        'group_input' => 'input, text, number, email, password, editor, options, select',
                        'input_placeholder' => 'any field',
                        'call_back' => 'no',
                        'input_validation' => 'callback_valid_alpha_numeric_spaces_underscores'
                     ],
                     [ 
                        'validation' => 'is_natural', 
                        'input_able' => 'no', 
                        'group_input' => 'input, text, number',
                        'input_placeholder' => '',
                        'call_back' => 'no',
                        'input_validation' => ''
                     ],
                     [ 
                        'validation' => 'is_natural_no_zero', 
                        'input_able' => 'no', 
                        'group_input' => 'input, text, number',
                        'input_placeholder' => '',
                        'call_back' => 'no',
                        'input_validation' => ''
                     ],
                     [ 
                        'validation' => 'less_than', 
                        'input_able' => 'yes', 
                        'group_input' => 'input, text, number',
                        'input_placeholder' => '',
                        'call_back' => 'no',
                        'input_validation' => 'numeric'
                     ],
                     [ 
                        'validation' => 'less_than_equal_to', 
                        'input_able' => 'yes', 
                        'group_input' => 'input, text, number',
                        'input_placeholder' => '',
                        'call_back' => 'no',
                        'input_validation' => 'numeric'
                     ],
                     [ 
                        'validation' => 'greater_than', 
                        'input_able' => 'yes', 
                        'group_input' => 'input, text, number',
                        'input_placeholder' => '',
                        'call_back' => 'no',
                        'input_validation' => 'numeric'
                     ],
                     [ 
                        'validation' => 'greater_than_equal_to', 
                        'input_able' => 'yes', 
                        'group_input' => 'input, text, number',
                        'input_placeholder' => '',
                        'call_back' => 'no',
                        'input_validation' => 'numeric'
                     ],
                     [ 
                        'validation' => 'in_list', 
                        'input_able' => 'yes', 
                        'group_input' => 'input, text, number, select, options',
                        'input_placeholder' => '',
                        'call_back' => 'no',
                        'input_validation' => 'callback_valid_multiple_value'
                     ],
                     [ 
                        'validation' => 'valid_ip', 
                        'input_able' => 'no', 
                        'group_input' => 'input, text',
                        'input_placeholder' => '',
                        'call_back' => 'no',
                        'input_validation' => ''
                     ],

                ]);


                //create table crud custom value
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'crud_field_id' => array(
                                'type' => 'INT',
                        ),
                        'crud_id' => array(
                                'type' => 'INT',
                        ),
                        'option_value' => array(
                                'type' => 'TEXT',
                        ),
                        'option_label' => array(
                                'type' => 'TEXT',
                        ),
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('crud_custom_option');


                //insert dummy data
                $this->db->insert_batch('aauth_perms', [
                    [ 'name' => 'menu_dashboard' ],
                    [ 'name' => 'menu_crud_builder' ],
                    [ 'name' => 'menu_api_builder' ],
                    [ 'name' => 'menu_page_builder' ],
                    [ 'name' => 'menu_form_builder' ],
                    [ 'name' => 'menu_menu' ],
                    [ 'name' => 'menu_auth' ],
                    [ 'name' => 'menu_user' ],
                    [ 'name' => 'menu_group' ],
                    [ 'name' => 'menu_access' ],
                    [ 'name' => 'menu_permission' ],
                    [ 'name' => 'menu_api_documentation' ],
                    [ 'name' => 'menu_web_documentation' ],
                    [ 'name' => 'menu_settings' ],

                    [ 'name' => 'user_list' ],
                    [ 'name' => 'user_update_status' ],
                    [ 'name' => 'user_export' ],
                    [ 'name' => 'user_add' ],
                    [ 'name' => 'user_update' ],
                    [ 'name' => 'user_update_profile' ],
                    [ 'name' => 'user_update_password' ],
                    [ 'name' => 'user_profile' ],
                    [ 'name' => 'user_view' ],
                    [ 'name' => 'user_delete' ],

                    [ 'name' => 'blog_list' ],
                    [ 'name' => 'blog_export' ],
                    [ 'name' => 'blog_add' ],
                    [ 'name' => 'blog_update' ],
                    [ 'name' => 'blog_view' ],
                    [ 'name' => 'blog_delete' ],

                    [ 'name' => 'form_list' ],
                    [ 'name' => 'form_export' ],
                    [ 'name' => 'form_add' ],
                    [ 'name' => 'form_update' ],
                    [ 'name' => 'form_view' ],
                    [ 'name' => 'form_manage' ],
                    [ 'name' => 'form_delete' ],

                    [ 'name' => 'crud_list' ],
                    [ 'name' => 'crud_export' ],
                    [ 'name' => 'crud_add' ],
                    [ 'name' => 'crud_update' ],
                    [ 'name' => 'crud_view' ],
                    [ 'name' => 'crud_delete' ],

                    [ 'name' => 'rest_list' ],
                    [ 'name' => 'rest_export' ],
                    [ 'name' => 'rest_add' ],
                    [ 'name' => 'rest_update' ],
                    [ 'name' => 'rest_view' ],
                    [ 'name' => 'rest_delete' ],

                    [ 'name' => 'group_list' ],
                    [ 'name' => 'group_export' ],
                    [ 'name' => 'group_add' ],
                    [ 'name' => 'group_update' ],
                    [ 'name' => 'group_view' ],
                    [ 'name' => 'group_delete' ],

                    [ 'name' => 'permission_list' ],
                    [ 'name' => 'permission_export' ],
                    [ 'name' => 'permission_add' ],
                    [ 'name' => 'permission_update' ],
                    [ 'name' => 'permission_view' ],
                    [ 'name' => 'permission_delete' ],

                    [ 'name' => 'access_list' ],
                    [ 'name' => 'access_add' ],
                    [ 'name' => 'access_update' ],
                    [ 'name' => 'menu_list' ],

                    [ 'name' => 'menu_add' ],
                    [ 'name' => 'menu_update' ],
                    [ 'name' => 'menu_delete' ],
                    [ 'name' => 'menu_save_ordering' ],
                    [ 'name' => 'menu_type_add' ],

                    [ 'name' => 'page_list' ],
                    [ 'name' => 'page_export' ],
                    [ 'name' => 'page_add' ],
                    [ 'name' => 'page_update' ],
                    [ 'name' => 'page_view' ],
                    [ 'name' => 'page_delete' ],

                    [ 'name' => 'setting' ],
                    [ 'name' => 'setting_update' ],
                ]); 

                //insert dummy data
                $this->db->insert_batch('blog_category', [
                    [ 'category_name'           => 'Technology' ],
                ]);   


                //insert dummy data
                $this->db->insert_batch('menu_type', [
                    [ 'name' => 'side menu' ],
                    [ 'name' => 'top menu' ],
                ]);


                //insert dummy data menu admin
                $this->db->insert_batch('menu', [
                    [ 
                        'label'         => 'MAIN NAVIGATION', 
                        'link'          => 'administrator/dashboard', 
                        'sort'          => 1, 
                        'parent'        => '',   
                        'icon'          => '',   
                        'menu_type_id'  => 1 ,
                        'type'          => 'label',
                        'icon_color'    => ''
                    ],
                    [ 
                        'label'         => 'Dashboard', 
                        'link'          => 'administrator/dashboard', 
                        'sort'          => 2, 
                        'parent'        => '',   
                        'icon'          => 'fa-dashboard',   
                        'menu_type_id'  => 1 ,
                        'type'          => 'menu',
                        'icon_color'    => ''
                    ],
                    [ 
                        'label'         => 'CRUD Builder', 
                        'link'          => 'administrator/crud', 
                        'sort'          => 3, 
                        'parent'        => '',   
                        'icon'          => 'fa-table',   
                        'menu_type_id'  => 1 ,
                        'type'          => 'menu',
                        'icon_color'    => ''
                    ],
                    [ 
                        'label'         => 'API Builder', 
                        'link'          => 'administrator/rest', 
                        'sort'          => 4, 
                        'parent'        => '',   
                        'icon'          => 'fa-code',   
                        'menu_type_id'  => 1 ,
                        'type'          => 'menu',
                        'icon_color'    => ''
                    ],
                    [ 
                        'label'         => 'Page Builder', 
                        'link'          => 'administrator/page', 
                        'sort'          => 5, 
                        'parent'        => '',   
                        'icon'          => 'fa-file-o',   
                        'menu_type_id'  => 1 ,
                        'type'          => 'menu',
                        'icon_color'    => ''
                    ],
                    [ 
                        'label'         => 'Form Builder', 
                        'link'          => 'administrator/form', 
                        'sort'          => 6, 
                        'parent'        => '',   
                        'icon'          => 'fa-newspaper-o',   
                        'menu_type_id'  => 1 ,
                        'type'          => 'menu',
                        'icon_color'    => ''
                    ],
                    [ 
                        'label'         => 'Menu', 
                        'link'          => 'administrator/menu', 
                        'sort'          => 7, 
                        'parent'        => '',   
                        'icon'          => 'fa-bars',   
                        'menu_type_id'  => 1 ,
                        'type'          => 'menu',
                        'icon_color'    => ''
                    ],
                    [ 
                        'label'         => 'Auth', 
                        'link'          => '', 
                        'sort'          => 8, 
                        'parent'        => '',   
                        'icon'          => 'fa-shield',   
                        'menu_type_id'  => 1 ,
                        'type'          => 'menu',
                        'icon_color'    => ''
                    ],
                        [ 
                            'label'         => 'User', 
                            'link'          => 'administrator/user', 
                            'sort'          => 9, 
                            'parent'        => 8,   
                            'icon'          => '',   
                            'menu_type_id'  => 1 ,
                            'type'          => 'menu',
                            'icon_color'    => ''
                        ],
                        [ 
                            'label'         => 'Groups', 
                            'link'          => 'administrator/group', 
                            'sort'          => 10, 
                            'parent'        => 8,   
                            'icon'          => '',   
                            'menu_type_id'  => 1 ,
                            'type'          => 'menu',
                            'icon_color'    => ''
                        ],
                        [ 
                            'label'         => 'Access', 
                            'link'          => 'administrator/access', 
                            'sort'          => 11, 
                            'parent'        => 8,   
                            'icon'          => '',   
                            'menu_type_id'  => 1 ,
                            'type'          => 'menu',
                            'icon_color'    => ''
                        ],
                        [ 
                            'label'         => 'Permission', 
                            'link'          => 'administrator/permission', 
                            'sort'          => 12, 
                            'parent'        => 8,   
                            'icon'          => '',   
                            'menu_type_id'  => 1 ,
                            'type'          => 'menu',
                            'icon_color'    => ''
                        ],
                        [ 
                            'label'         => 'API Keys', 
                            'link'          => 'administrator/keys', 
                            'sort'          => 13, 
                            'parent'        => 8,   
                            'icon'          => '',   
                            'menu_type_id'  => 1 ,
                            'type'          => 'menu',
                            'icon_color'    => ''
                        ],
                    [ 
                        'label'         => 'OTHER', 
                        'link'          => '', 
                        'sort'          => 13, 
                        'parent'        => '',   
                        'icon'          => '',   
                        'menu_type_id'  => 1 ,
                        'type'          => 'label',
                        'icon_color'    => ''
                    ],
                    [ 
                        'label'         => 'Settings', 
                        'link'          => 'administrator/setting', 
                        'sort'          => 14, 
                        'parent'        => '',   
                        'icon'          => 'fa-circle-o',   
                        'menu_type_id'  => 1 ,
                        'type'          => 'menu',
                        'icon_color'    => 'text-red'
                    ],
                    [ 
                        'label'         => 'Web Documentation', 
                        'link'          => 'administrator/doc/web', 
                        'sort'          => 15, 
                        'parent'        => '',   
                        'icon'          => 'fa-circle-o',   
                        'menu_type_id'  => 1 ,
                        'type'          => 'menu',
                        'icon_color'    => 'text-blue'
                    ],
                    [ 
                        'label'         => 'API Documentation', 
                        'link'          => 'administrator/doc/api', 
                        'sort'          => 16, 
                        'parent'        => '',   
                        'icon'          => 'fa-circle-o',   
                        'menu_type_id'  => 1 ,
                        'type'          => 'menu',
                        'icon_color'    => 'text-yellow'
                    ],
                ]);


                //insert dummy data menu front
                $this->db->insert_batch('menu', [
                    [ 
                        'label'         => 'Home', 
                        'link'          => '/', 
                        'sort'          => 1, 
                        'parent'        => '',   
                        'icon'          => '',   
                        'menu_type_id'  => 2 ,
                        'type'          => 'menu',
                        'icon_color'    => ''
                    ],
                    [ 
                        'label'         => 'About', 
                        'link'          => 'page/about', 
                        'sort'          => 2, 
                        'parent'        => '',   
                        'icon'          => '',   
                        'menu_type_id'  => 2 ,
                        'type'          => 'menu',
                        'icon_color'    => ''
                    ],
                    [ 
                        'label'         => 'Get Started', 
                        'link'          => 'page/get-started', 
                        'sort'          => 3, 
                        'parent'        => '',   
                        'icon'          => '',   
                        'menu_type_id'  => 2 ,
                        'type'          => 'menu',
                        'icon_color'    => ''
                    ],
                    [ 
                        'label'         => 'Dashboard', 
                        'link'          => 'administrator/dashboard', 
                        'sort'          => 4, 
                        'parent'        => '',   
                        'icon'          => '',   
                        'menu_type_id'  => 2 ,
                        'type'          => 'menu',
                        'icon_color'    => ''
                    ]
                ]); 

                
                //create table keys
                $this->dbforge->add_field(array(
                        'id' => array(
                                'type' => 'INT',
                                'constraint' => 11,
                                'unsigned' => TRUE,
                                'auto_increment' => TRUE
                        ),
                        'user_id' => array(
                                'type' => 'INT',
                        ),
                        'key' => array(
                                'type' => 'VARCHAR',
                                'constraint' => 40,
                        ),
                        'level' => array(
                                'type' => 'INT',
                                'constraint' => 2,
                        ),
                        'ignore_limits' => array(
                                'type' => 'TINYINT',
                                'constraint' => 1,
                        ),
                        'is_private_key' => array(
                                'type' => 'TINYINT',
                                'constraint' => 1,
                        ),
                        'ip_addresses' => array(
                                'type' => 'TEXT',
                                'null' => true,
                        ),
                        'date_created' => array(
                                'type' => 'TIMESTAMP',
                        ),
                ));
                $this->dbforge->add_key('id', TRUE);
                $this->dbforge->create_table('keys');

                
                //insert dummy data
                $this->db->insert_batch('keys', [
                    [ 
                        'key' => strtoupper(md5(generate_key())),
                        'is_private_key' => 0,
                        'date_created' => date('Y-m-d H:i:s')
                    ],
                ]);


                //insert icon data
                $this->db->insert_batch('menu_icon', [
                    ["class_name" => "fa-500px"],
                    ["class_name" => "fa-adjust"],
                    ["class_name" => "fa-adn"],
                    ["class_name" => "fa-align"],
                    ["class_name" => "fa-align"],
                    ["class_name" => "fa-align"],
                    ["class_name" => "fa-align"],
                    ["class_name" => "fa-amazon"],
                    ["class_name" => "fa-ambulance"],
                    ["class_name" => "fa-american"],
                    ["class_name" => "fa-anchor"],
                    ["class_name" => "fa-android"],
                    ["class_name" => "fa-angellist"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-apple"],
                    ["class_name" => "fa-archive"],
                    ["class_name" => "fa-area"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrows"],
                    ["class_name" => "fa-arrows"],
                    ["class_name" => "fa-arrows"],
                    ["class_name" => "fa-arrows"],
                    ["class_name" => "fa-asl"],
                    ["class_name" => "fa-assistive"],
                    ["class_name" => "fa-asterisk"],
                    ["class_name" => "fa-at"],
                    ["class_name" => "fa-audio"],
                    ["class_name" => "fa-automobile"],
                    ["class_name" => "fa-backward"],
                    ["class_name" => "fa-balance"],
                    ["class_name" => "fa-ban"],
                    ["class_name" => "fa-bank"],
                    ["class_name" => "fa-bar"],
                    ["class_name" => "fa-bar"],
                    ["class_name" => "fa-barcode"],
                    ["class_name" => "fa-bars"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-bed"],
                    ["class_name" => "fa-beer"],
                    ["class_name" => "fa-behance"],
                    ["class_name" => "fa-behance"],
                    ["class_name" => "fa-bell"],
                    ["class_name" => "fa-bell"],
                    ["class_name" => "fa-bell"],
                    ["class_name" => "fa-bell"],
                    ["class_name" => "fa-bicycle"],
                    ["class_name" => "fa-binoculars"],
                    ["class_name" => "fa-birthday"],
                    ["class_name" => "fa-bitbucket"],
                    ["class_name" => "fa-bitbucket"],
                    ["class_name" => "fa-bitcoin"],
                    ["class_name" => "fa-black"],
                    ["class_name" => "fa-blind"],
                    ["class_name" => "fa-bluetooth"],
                    ["class_name" => "fa-bluetooth"],
                    ["class_name" => "fa-bold"],
                    ["class_name" => "fa-bolt"],
                    ["class_name" => "fa-bomb"],
                    ["class_name" => "fa-book"],
                    ["class_name" => "fa-bookmark"],
                    ["class_name" => "fa-bookmark"],
                    ["class_name" => "fa-braille"],
                    ["class_name" => "fa-briefcase"],
                    ["class_name" => "fa-btc"],
                    ["class_name" => "fa-bug"],
                    ["class_name" => "fa-building"],
                    ["class_name" => "fa-building"],
                    ["class_name" => "fa-bullhorn"],
                    ["class_name" => "fa-bullseye"],
                    ["class_name" => "fa-bus"],
                    ["class_name" => "fa-buysellads"],
                    ["class_name" => "fa-cab"],
                    ["class_name" => "fa-calculator"],
                    ["class_name" => "fa-calendar"],
                    ["class_name" => "fa-calendar"],
                    ["class_name" => "fa-calendar"],
                    ["class_name" => "fa-calendar"],
                    ["class_name" => "fa-calendar"],
                    ["class_name" => "fa-calendar"],
                    ["class_name" => "fa-camera"],
                    ["class_name" => "fa-camera"],
                    ["class_name" => "fa-car"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-cart"],
                    ["class_name" => "fa-cart"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-certificate"],
                    ["class_name" => "fa-chain"],
                    ["class_name" => "fa-chain"],
                    ["class_name" => "fa-check"],
                    ["class_name" => "fa-check"],
                    ["class_name" => "fa-check"],
                    ["class_name" => "fa-check"],
                    ["class_name" => "fa-check"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-child"],
                    ["class_name" => "fa-chrome"],
                    ["class_name" => "fa-circle"],
                    ["class_name" => "fa-circle"],
                    ["class_name" => "fa-circle"],
                    ["class_name" => "fa-circle"],
                    ["class_name" => "fa-clipboard"],
                    ["class_name" => "fa-clock"],
                    ["class_name" => "fa-clone"],
                    ["class_name" => "fa-close"],
                    ["class_name" => "fa-cloud"],
                    ["class_name" => "fa-cloud"],
                    ["class_name" => "fa-cloud"],
                    ["class_name" => "fa-cny"],
                    ["class_name" => "fa-code"],
                    ["class_name" => "fa-code"],
                    ["class_name" => "fa-codepen"],
                    ["class_name" => "fa-codiepie"],
                    ["class_name" => "fa-coffee"],
                    ["class_name" => "fa-cog"],
                    ["class_name" => "fa-cogs"],
                    ["class_name" => "fa-columns"],
                    ["class_name" => "fa-comment"],
                    ["class_name" => "fa-comment"],
                    ["class_name" => "fa-commenting"],
                    ["class_name" => "fa-commenting"],
                    ["class_name" => "fa-comments"],
                    ["class_name" => "fa-comments"],
                    ["class_name" => "fa-compass"],
                    ["class_name" => "fa-compress"],
                    ["class_name" => "fa-connectdevelop"],
                    ["class_name" => "fa-contao"],
                    ["class_name" => "fa-copy"],
                    ["class_name" => "fa-copyright"],
                    ["class_name" => "fa-creative"],
                    ["class_name" => "fa-credit"],
                    ["class_name" => "fa-credit"],
                    ["class_name" => "fa-crop"],
                    ["class_name" => "fa-crosshairs"],
                    ["class_name" => "fa-css3"],
                    ["class_name" => "fa-cube"],
                    ["class_name" => "fa-cubes"],
                    ["class_name" => "fa-cut"],
                    ["class_name" => "fa-cutlery"],
                    ["class_name" => "fa-dashboard"],
                    ["class_name" => "fa-dashcube"],
                    ["class_name" => "fa-database"],
                    ["class_name" => "fa-deaf"],
                    ["class_name" => "fa-deafness"],
                    ["class_name" => "fa-dedent"],
                    ["class_name" => "fa-delicious"],
                    ["class_name" => "fa-desktop"],
                    ["class_name" => "fa-deviantart"],
                    ["class_name" => "fa-diamond"],
                    ["class_name" => "fa-digg"],
                    ["class_name" => "fa-dollar"],
                    ["class_name" => "fa-dot"],
                    ["class_name" => "fa-download"],
                    ["class_name" => "fa-dribbble"],
                    ["class_name" => "fa-dropbox"],
                    ["class_name" => "fa-drupal"],
                    ["class_name" => "fa-edge"],
                    ["class_name" => "fa-edit"],
                    ["class_name" => "fa-eject"],
                    ["class_name" => "fa-ellipsis"],
                    ["class_name" => "fa-ellipsis"],
                    ["class_name" => "fa-empire"],
                    ["class_name" => "fa-envelope"],
                    ["class_name" => "fa-envelope"],
                    ["class_name" => "fa-envelope"],
                    ["class_name" => "fa-envira"],
                    ["class_name" => "fa-eraser"],
                    ["class_name" => "fa-eur"],
                    ["class_name" => "fa-euro"],
                    ["class_name" => "fa-exchange"],
                    ["class_name" => "fa-exclamation"],
                    ["class_name" => "fa-exclamation"],
                    ["class_name" => "fa-exclamation"],
                    ["class_name" => "fa-expand"],
                    ["class_name" => "fa-expeditedssl"],
                    ["class_name" => "fa-external"],
                    ["class_name" => "fa-external"],
                    ["class_name" => "fa-eye"],
                    ["class_name" => "fa-eye"],
                    ["class_name" => "fa-eyedropper"],
                    ["class_name" => "fa-fa"],
                    ["class_name" => "fa-facebook"],
                    ["class_name" => "fa-facebook"],
                    ["class_name" => "fa-facebook"],
                    ["class_name" => "fa-facebook"],
                    ["class_name" => "fa-fast"],
                    ["class_name" => "fa-fast"],
                    ["class_name" => "fa-fax"],
                    ["class_name" => "fa-feed"],
                    ["class_name" => "fa-female"],
                    ["class_name" => "fa-fighter"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-files"],
                    ["class_name" => "fa-film"],
                    ["class_name" => "fa-filter"],
                    ["class_name" => "fa-fire"],
                    ["class_name" => "fa-fire"],
                    ["class_name" => "fa-firefox"],
                    ["class_name" => "fa-first"],
                    ["class_name" => "fa-flag"],
                    ["class_name" => "fa-flag"],
                    ["class_name" => "fa-flag"],
                    ["class_name" => "fa-flash"],
                    ["class_name" => "fa-flask"],
                    ["class_name" => "fa-flickr"],
                    ["class_name" => "fa-floppy"],
                    ["class_name" => "fa-folder"],
                    ["class_name" => "fa-folder"],
                    ["class_name" => "fa-folder"],
                    ["class_name" => "fa-folder"],
                    ["class_name" => "fa-font"],
                    ["class_name" => "fa-font"],
                    ["class_name" => "fa-fonticons"],
                    ["class_name" => "fa-fort"],
                    ["class_name" => "fa-forumbee"],
                    ["class_name" => "fa-forward"],
                    ["class_name" => "fa-foursquare"],
                    ["class_name" => "fa-frown"],
                    ["class_name" => "fa-futbol"],
                    ["class_name" => "fa-gamepad"],
                    ["class_name" => "fa-gavel"],
                    ["class_name" => "fa-gbp"],
                    ["class_name" => "fa-ge"],
                    ["class_name" => "fa-gear"],
                    ["class_name" => "fa-gears"],
                    ["class_name" => "fa-genderless"],
                    ["class_name" => "fa-get"],
                    ["class_name" => "fa-gg"],
                    ["class_name" => "fa-gg"],
                    ["class_name" => "fa-gift"],
                    ["class_name" => "fa-git"],
                    ["class_name" => "fa-git"],
                    ["class_name" => "fa-github"],
                    ["class_name" => "fa-github"],
                    ["class_name" => "fa-github"],
                    ["class_name" => "fa-gitlab"],
                    ["class_name" => "fa-gittip"],
                    ["class_name" => "fa-glass"],
                    ["class_name" => "fa-glide"],
                    ["class_name" => "fa-glide"],
                    ["class_name" => "fa-globe"],
                    ["class_name" => "fa-google"],
                    ["class_name" => "fa-google"],
                    ["class_name" => "fa-google"],
                    ["class_name" => "fa-google"],
                    ["class_name" => "fa-google"],
                    ["class_name" => "fa-google"],
                    ["class_name" => "fa-graduation"],
                    ["class_name" => "fa-gratipay"],
                    ["class_name" => "fa-group"],
                    ["class_name" => "fa-h"],
                    ["class_name" => "fa-hacker"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hard"],
                    ["class_name" => "fa-hashtag"],
                    ["class_name" => "fa-hdd"],
                    ["class_name" => "fa-header"],
                    ["class_name" => "fa-headphones"],
                    ["class_name" => "fa-heart"],
                    ["class_name" => "fa-heart"],
                    ["class_name" => "fa-heartbeat"],
                    ["class_name" => "fa-history"],
                    ["class_name" => "fa-home"],
                    ["class_name" => "fa-hospital"],
                    ["class_name" => "fa-hotel"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-houzz"],
                    ["class_name" => "fa-html5"],
                    ["class_name" => "fa-i"],
                    ["class_name" => "fa-ils"],
                    ["class_name" => "fa-image"],
                    ["class_name" => "fa-inbox"],
                    ["class_name" => "fa-indent"],
                    ["class_name" => "fa-industry"],
                    ["class_name" => "fa-info"],
                    ["class_name" => "fa-info"],
                    ["class_name" => "fa-inr"],
                    ["class_name" => "fa-instagram"],
                    ["class_name" => "fa-institution"],
                    ["class_name" => "fa-internet"],
                    ["class_name" => "fa-intersex"],
                    ["class_name" => "fa-ioxhost"],
                    ["class_name" => "fa-italic"],
                    ["class_name" => "fa-joomla"],
                    ["class_name" => "fa-jpy"],
                    ["class_name" => "fa-jsfiddle"],
                    ["class_name" => "fa-key"],
                    ["class_name" => "fa-keyboard"],
                    ["class_name" => "fa-krw"],
                    ["class_name" => "fa-language"],
                    ["class_name" => "fa-laptop"],
                    ["class_name" => "fa-lastfm"],
                    ["class_name" => "fa-lastfm"],
                    ["class_name" => "fa-leaf"],
                    ["class_name" => "fa-leanpub"],
                    ["class_name" => "fa-legal"],
                    ["class_name" => "fa-lemon"],
                    ["class_name" => "fa-level"],
                    ["class_name" => "fa-level"],
                    ["class_name" => "fa-life"],
                    ["class_name" => "fa-life"],
                    ["class_name" => "fa-life"],
                    ["class_name" => "fa-life"],
                    ["class_name" => "fa-lightbulb"],
                    ["class_name" => "fa-line"],
                    ["class_name" => "fa-link"],
                    ["class_name" => "fa-linkedin"],
                    ["class_name" => "fa-linkedin"],
                    ["class_name" => "fa-linux"],
                    ["class_name" => "fa-list"],
                    ["class_name" => "fa-list"],
                    ["class_name" => "fa-list"],
                    ["class_name" => "fa-list"],
                    ["class_name" => "fa-location"],
                    ["class_name" => "fa-lock"],
                    ["class_name" => "fa-long"],
                    ["class_name" => "fa-long"],
                    ["class_name" => "fa-long"],
                    ["class_name" => "fa-long"],
                    ["class_name" => "fa-low"],
                    ["class_name" => "fa-magic"],
                    ["class_name" => "fa-magnet"],
                    ["class_name" => "fa-mail"],
                    ["class_name" => "fa-mail"],
                    ["class_name" => "fa-mail"],
                    ["class_name" => "fa-male"],
                    ["class_name" => "fa-map"],
                    ["class_name" => "fa-map"],
                    ["class_name" => "fa-map"],
                    ["class_name" => "fa-map"],
                    ["class_name" => "fa-map"],
                    ["class_name" => "fa-mars"],
                    ["class_name" => "fa-mars"],
                    ["class_name" => "fa-mars"],
                    ["class_name" => "fa-mars"],
                    ["class_name" => "fa-mars"],
                    ["class_name" => "fa-maxcdn"],
                    ["class_name" => "fa-meanpath"],
                    ["class_name" => "fa-medium"],
                    ["class_name" => "fa-medkit"],
                    ["class_name" => "fa-meh"],
                    ["class_name" => "fa-mercury"],
                    ["class_name" => "fa-microphone"],
                    ["class_name" => "fa-microphone"],
                    ["class_name" => "fa-minus"],
                    ["class_name" => "fa-minus"],
                    ["class_name" => "fa-minus"],
                    ["class_name" => "fa-minus"],
                    ["class_name" => "fa-mixcloud"],
                    ["class_name" => "fa-mobile"],
                    ["class_name" => "fa-mobile"],
                    ["class_name" => "fa-modx"],
                    ["class_name" => "fa-money"],
                    ["class_name" => "fa-moon"],
                    ["class_name" => "fa-mortar"],
                    ["class_name" => "fa-motorcycle"],
                    ["class_name" => "fa-mouse"],
                    ["class_name" => "fa-music"],
                    ["class_name" => "fa-navicon"],
                    ["class_name" => "fa-neuter"],
                    ["class_name" => "fa-newspaper"],
                    ["class_name" => "fa-object"],
                    ["class_name" => "fa-object"],
                    ["class_name" => "fa-odnoklassniki"],
                    ["class_name" => "fa-odnoklassniki"],
                    ["class_name" => "fa-opencart"],
                    ["class_name" => "fa-openid"],
                    ["class_name" => "fa-opera"],
                    ["class_name" => "fa-optin"],
                    ["class_name" => "fa-outdent"],
                    ["class_name" => "fa-pagelines"],
                    ["class_name" => "fa-paint"],
                    ["class_name" => "fa-paper"],
                    ["class_name" => "fa-paper"],
                    ["class_name" => "fa-paperclip"],
                    ["class_name" => "fa-paragraph"],
                    ["class_name" => "fa-paste"],
                    ["class_name" => "fa-pause"],
                    ["class_name" => "fa-pause"],
                    ["class_name" => "fa-pause"],
                    ["class_name" => "fa-paw"],
                    ["class_name" => "fa-paypal"],
                    ["class_name" => "fa-pencil"],
                    ["class_name" => "fa-pencil"],
                    ["class_name" => "fa-pencil"],
                    ["class_name" => "fa-percent"],
                    ["class_name" => "fa-phone"],
                    ["class_name" => "fa-phone"],
                    ["class_name" => "fa-photo"],
                    ["class_name" => "fa-picture"],
                    ["class_name" => "fa-pie"],
                    ["class_name" => "fa-pied"],
                    ["class_name" => "fa-pied"],
                    ["class_name" => "fa-pied"],
                    ["class_name" => "fa-pinterest"],
                    ["class_name" => "fa-pinterest"],
                    ["class_name" => "fa-pinterest"],
                    ["class_name" => "fa-plane"],
                    ["class_name" => "fa-play"],
                    ["class_name" => "fa-play"],
                    ["class_name" => "fa-play"],
                    ["class_name" => "fa-plug"],
                    ["class_name" => "fa-plus"],
                    ["class_name" => "fa-plus"],
                    ["class_name" => "fa-plus"],
                    ["class_name" => "fa-plus"],
                    ["class_name" => "fa-power"],
                    ["class_name" => "fa-print"],
                    ["class_name" => "fa-product"],
                    ["class_name" => "fa-puzzle"],
                    ["class_name" => "fa-qq"],
                    ["class_name" => "fa-qrcode"],
                    ["class_name" => "fa-question"],
                    ["class_name" => "fa-question"],
                    ["class_name" => "fa-question"],
                    ["class_name" => "fa-quote"],
                    ["class_name" => "fa-quote"],
                    ["class_name" => "fa-ra"],
                    ["class_name" => "fa-random"],
                    ["class_name" => "fa-rebel"],
                    ["class_name" => "fa-recycle"],
                    ["class_name" => "fa-reddit"],
                    ["class_name" => "fa-reddit"],
                    ["class_name" => "fa-reddit"],
                    ["class_name" => "fa-refresh"],
                    ["class_name" => "fa-registered"],
                    ["class_name" => "fa-remove"],
                    ["class_name" => "fa-renren"],
                    ["class_name" => "fa-reorder"],
                    ["class_name" => "fa-repeat"],
                    ["class_name" => "fa-reply"],
                    ["class_name" => "fa-reply"],
                    ["class_name" => "fa-resistance"],
                    ["class_name" => "fa-retweet"],
                    ["class_name" => "fa-rmb"],
                    ["class_name" => "fa-road"],
                    ["class_name" => "fa-rocket"],
                    ["class_name" => "fa-rotate"],
                    ["class_name" => "fa-rotate"],
                    ["class_name" => "fa-rouble"],
                    ["class_name" => "fa-rss"],
                    ["class_name" => "fa-rss"],
                    ["class_name" => "fa-rub"],
                    ["class_name" => "fa-ruble"],
                    ["class_name" => "fa-rupee"],
                    ["class_name" => "fa-safari"],
                    ["class_name" => "fa-save"],
                    ["class_name" => "fa-scissors"],
                    ["class_name" => "fa-scribd"],
                    ["class_name" => "fa-search"],
                    ["class_name" => "fa-search"],
                    ["class_name" => "fa-search"],
                    ["class_name" => "fa-sellsy"],
                    ["class_name" => "fa-send"],
                    ["class_name" => "fa-send"],
                    ["class_name" => "fa-server"],
                    ["class_name" => "fa-share"],
                    ["class_name" => "fa-share"],
                    ["class_name" => "fa-share"],
                    ["class_name" => "fa-share"],
                    ["class_name" => "fa-share"],
                    ["class_name" => "fa-shekel"],
                    ["class_name" => "fa-sheqel"],
                    ["class_name" => "fa-shield"],
                    ["class_name" => "fa-ship"],
                    ["class_name" => "fa-shirtsinbulk"],
                    ["class_name" => "fa-shopping"],
                    ["class_name" => "fa-shopping"],
                    ["class_name" => "fa-shopping"],
                    ["class_name" => "fa-sign"],
                    ["class_name" => "fa-sign"],
                    ["class_name" => "fa-sign"],
                    ["class_name" => "fa-signal"],
                    ["class_name" => "fa-signing"],
                    ["class_name" => "fa-simplybuilt"],
                    ["class_name" => "fa-sitemap"],
                    ["class_name" => "fa-skyatlas"],
                    ["class_name" => "fa-skype"],
                    ["class_name" => "fa-slack"],
                    ["class_name" => "fa-sliders"],
                    ["class_name" => "fa-slideshare"],
                    ["class_name" => "fa-smile"],
                    ["class_name" => "fa-snapchat"],
                    ["class_name" => "fa-snapchat"],
                    ["class_name" => "fa-snapchat"],
                    ["class_name" => "fa-soccer"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-soundcloud"],
                    ["class_name" => "fa-space"],
                    ["class_name" => "fa-spinner"],
                    ["class_name" => "fa-spoon"],
                    ["class_name" => "fa-spotify"],
                    ["class_name" => "fa-square"],
                    ["class_name" => "fa-square"],
                    ["class_name" => "fa-stack"],
                    ["class_name" => "fa-stack"],
                    ["class_name" => "fa-star"],
                    ["class_name" => "fa-star"],
                    ["class_name" => "fa-star"],
                    ["class_name" => "fa-star"],
                    ["class_name" => "fa-star"],
                    ["class_name" => "fa-star"],
                    ["class_name" => "fa-steam"],
                    ["class_name" => "fa-steam"],
                    ["class_name" => "fa-step"],
                    ["class_name" => "fa-step"],
                    ["class_name" => "fa-stethoscope"],
                    ["class_name" => "fa-sticky"],
                    ["class_name" => "fa-sticky"],
                    ["class_name" => "fa-stop"],
                    ["class_name" => "fa-stop"],
                    ["class_name" => "fa-stop"],
                    ["class_name" => "fa-street"],
                    ["class_name" => "fa-strikethrough"],
                    ["class_name" => "fa-stumbleupon"],
                    ["class_name" => "fa-stumbleupon"],
                    ["class_name" => "fa-subscript"],
                    ["class_name" => "fa-subway"],
                    ["class_name" => "fa-suitcase"],
                    ["class_name" => "fa-sun"],
                    ["class_name" => "fa-superscript"],
                    ["class_name" => "fa-support"],
                    ["class_name" => "fa-table"],
                    ["class_name" => "fa-tablet"],
                    ["class_name" => "fa-tachometer"],
                    ["class_name" => "fa-tag"],
                    ["class_name" => "fa-tags"],
                    ["class_name" => "fa-tasks"],
                    ["class_name" => "fa-taxi"],
                    ["class_name" => "fa-television"],
                    ["class_name" => "fa-tencent"],
                    ["class_name" => "fa-terminal"],
                    ["class_name" => "fa-text"],
                    ["class_name" => "fa-text"],
                    ["class_name" => "fa-th"],
                    ["class_name" => "fa-th"],
                    ["class_name" => "fa-th"],
                    ["class_name" => "fa-themeisle"],
                    ["class_name" => "fa-thumb"],
                    ["class_name" => "fa-thumbs"],
                    ["class_name" => "fa-thumbs"],
                    ["class_name" => "fa-thumbs"],
                    ["class_name" => "fa-thumbs"],
                    ["class_name" => "fa-ticket"],
                    ["class_name" => "fa-times"],
                    ["class_name" => "fa-times"],
                    ["class_name" => "fa-times"],
                    ["class_name" => "fa-tint"],
                    ["class_name" => "fa-toggle"],
                    ["class_name" => "fa-toggle"],
                    ["class_name" => "fa-toggle"],
                    ["class_name" => "fa-toggle"],
                    ["class_name" => "fa-toggle"],
                    ["class_name" => "fa-toggle"],
                    ["class_name" => "fa-trademark"],
                    ["class_name" => "fa-train"],
                    ["class_name" => "fa-transgender"],
                    ["class_name" => "fa-transgender"],
                    ["class_name" => "fa-trash"],
                    ["class_name" => "fa-trash"],
                    ["class_name" => "fa-tree"],
                    ["class_name" => "fa-trello"],
                    ["class_name" => "fa-tripadvisor"],
                    ["class_name" => "fa-trophy"],
                    ["class_name" => "fa-truck"],
                    ["class_name" => "fa-try"],
                    ["class_name" => "fa-tty"],
                    ["class_name" => "fa-tumblr"],
                    ["class_name" => "fa-tumblr"],
                    ["class_name" => "fa-turkish"],
                    ["class_name" => "fa-tv"],
                    ["class_name" => "fa-twitch"],
                    ["class_name" => "fa-twitter"],
                    ["class_name" => "fa-twitter"],
                    ["class_name" => "fa-umbrella"],
                    ["class_name" => "fa-underline"],
                    ["class_name" => "fa-undo"],
                    ["class_name" => "fa-universal"],
                    ["class_name" => "fa-university"],
                    ["class_name" => "fa-unlink"],
                    ["class_name" => "fa-unlock"],
                    ["class_name" => "fa-unlock"],
                    ["class_name" => "fa-unsorted"],
                    ["class_name" => "fa-upload"],
                    ["class_name" => "fa-usb"],
                    ["class_name" => "fa-usd"],
                    ["class_name" => "fa-user"],
                    ["class_name" => "fa-user"],
                    ["class_name" => "fa-user"],
                    ["class_name" => "fa-user"],
                    ["class_name" => "fa-user"],
                    ["class_name" => "fa-users"],
                    ["class_name" => "fa-venus"],
                    ["class_name" => "fa-venus"],
                    ["class_name" => "fa-venus"],
                    ["class_name" => "fa-viacoin"],
                    ["class_name" => "fa-viadeo"],
                    ["class_name" => "fa-viadeo"],
                    ["class_name" => "fa-video"],
                    ["class_name" => "fa-vimeo"],
                    ["class_name" => "fa-vimeo"],
                    ["class_name" => "fa-vine"],
                    ["class_name" => "fa-vk"],
                    ["class_name" => "fa-volume"],
                    ["class_name" => "fa-volume"],
                    ["class_name" => "fa-volume"],
                    ["class_name" => "fa-volume"],
                    ["class_name" => "fa-warning"],
                    ["class_name" => "fa-wechat"],
                    ["class_name" => "fa-weibo"],
                    ["class_name" => "fa-weixin"],
                    ["class_name" => "fa-whatsapp"],
                    ["class_name" => "fa-wheelchair"],
                    ["class_name" => "fa-wheelchair"],
                    ["class_name" => "fa-wifi"],
                    ["class_name" => "fa-wikipedia"],
                    ["class_name" => "fa-windows"],
                    ["class_name" => "fa-won"],
                    ["class_name" => "fa-wordpress"],
                    ["class_name" => "fa-wpbeginner"],
                    ["class_name" => "fa-wpforms"],
                    ["class_name" => "fa-wrench"],
                    ["class_name" => "fa-xing"],
                    ["class_name" => "fa-xing"],
                    ["class_name" => "fa-y"],
                    ["class_name" => "fa-y"],
                    ["class_name" => "fa-yahoo"],
                    ["class_name" => "fa-yc"],
                    ["class_name" => "fa-yc"],
                    ["class_name" => "fa-yelp"],
                    ["class_name" => "fa-yen"],
                    ["class_name" => "fa-yoast"],
                    ["class_name" => "fa-youtube"],
                    ["class_name" => "fa-youtube"],
                    ["class_name" => "fa-youtube"],
                    ["class_name" => "fa-500px"],
                    ["class_name" => "fa-adjust"],
                    ["class_name" => "fa-adn"],
                    ["class_name" => "fa-align"],
                    ["class_name" => "fa-align"],
                    ["class_name" => "fa-align"],
                    ["class_name" => "fa-align"],
                    ["class_name" => "fa-amazon"],
                    ["class_name" => "fa-ambulance"],
                    ["class_name" => "fa-american"],
                    ["class_name" => "fa-anchor"],
                    ["class_name" => "fa-android"],
                    ["class_name" => "fa-angellist"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-angle"],
                    ["class_name" => "fa-apple"],
                    ["class_name" => "fa-archive"],
                    ["class_name" => "fa-area"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrow"],
                    ["class_name" => "fa-arrows"],
                    ["class_name" => "fa-arrows"],
                    ["class_name" => "fa-arrows"],
                    ["class_name" => "fa-arrows"],
                    ["class_name" => "fa-asl"],
                    ["class_name" => "fa-assistive"],
                    ["class_name" => "fa-asterisk"],
                    ["class_name" => "fa-at"],
                    ["class_name" => "fa-audio"],
                    ["class_name" => "fa-automobile"],
                    ["class_name" => "fa-backward"],
                    ["class_name" => "fa-balance"],
                    ["class_name" => "fa-ban"],
                    ["class_name" => "fa-bank"],
                    ["class_name" => "fa-bar"],
                    ["class_name" => "fa-bar"],
                    ["class_name" => "fa-barcode"],
                    ["class_name" => "fa-bars"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-battery"],
                    ["class_name" => "fa-bed"],
                    ["class_name" => "fa-beer"],
                    ["class_name" => "fa-behance"],
                    ["class_name" => "fa-behance"],
                    ["class_name" => "fa-bell"],
                    ["class_name" => "fa-bell"],
                    ["class_name" => "fa-bell"],
                    ["class_name" => "fa-bell"],
                    ["class_name" => "fa-bicycle"],
                    ["class_name" => "fa-binoculars"],
                    ["class_name" => "fa-birthday"],
                    ["class_name" => "fa-bitbucket"],
                    ["class_name" => "fa-bitbucket"],
                    ["class_name" => "fa-bitcoin"],
                    ["class_name" => "fa-black"],
                    ["class_name" => "fa-blind"],
                    ["class_name" => "fa-bluetooth"],
                    ["class_name" => "fa-bluetooth"],
                    ["class_name" => "fa-bold"],
                    ["class_name" => "fa-bolt"],
                    ["class_name" => "fa-bomb"],
                    ["class_name" => "fa-book"],
                    ["class_name" => "fa-bookmark"],
                    ["class_name" => "fa-bookmark"],
                    ["class_name" => "fa-braille"],
                    ["class_name" => "fa-briefcase"],
                    ["class_name" => "fa-btc"],
                    ["class_name" => "fa-bug"],
                    ["class_name" => "fa-building"],
                    ["class_name" => "fa-building"],
                    ["class_name" => "fa-bullhorn"],
                    ["class_name" => "fa-bullseye"],
                    ["class_name" => "fa-bus"],
                    ["class_name" => "fa-buysellads"],
                    ["class_name" => "fa-cab"],
                    ["class_name" => "fa-calculator"],
                    ["class_name" => "fa-calendar"],
                    ["class_name" => "fa-calendar"],
                    ["class_name" => "fa-calendar"],
                    ["class_name" => "fa-calendar"],
                    ["class_name" => "fa-calendar"],
                    ["class_name" => "fa-calendar"],
                    ["class_name" => "fa-camera"],
                    ["class_name" => "fa-camera"],
                    ["class_name" => "fa-car"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-caret"],
                    ["class_name" => "fa-cart"],
                    ["class_name" => "fa-cart"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-cc"],
                    ["class_name" => "fa-certificate"],
                    ["class_name" => "fa-chain"],
                    ["class_name" => "fa-chain"],
                    ["class_name" => "fa-check"],
                    ["class_name" => "fa-check"],
                    ["class_name" => "fa-check"],
                    ["class_name" => "fa-check"],
                    ["class_name" => "fa-check"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-chevron"],
                    ["class_name" => "fa-child"],
                    ["class_name" => "fa-chrome"],
                    ["class_name" => "fa-circle"],
                    ["class_name" => "fa-circle"],
                    ["class_name" => "fa-circle"],
                    ["class_name" => "fa-circle"],
                    ["class_name" => "fa-clipboard"],
                    ["class_name" => "fa-clock"],
                    ["class_name" => "fa-clone"],
                    ["class_name" => "fa-close"],
                    ["class_name" => "fa-cloud"],
                    ["class_name" => "fa-cloud"],
                    ["class_name" => "fa-cloud"],
                    ["class_name" => "fa-cny"],
                    ["class_name" => "fa-code"],
                    ["class_name" => "fa-code"],
                    ["class_name" => "fa-codepen"],
                    ["class_name" => "fa-codiepie"],
                    ["class_name" => "fa-coffee"],
                    ["class_name" => "fa-cog"],
                    ["class_name" => "fa-cogs"],
                    ["class_name" => "fa-columns"],
                    ["class_name" => "fa-comment"],
                    ["class_name" => "fa-comment"],
                    ["class_name" => "fa-commenting"],
                    ["class_name" => "fa-commenting"],
                    ["class_name" => "fa-comments"],
                    ["class_name" => "fa-comments"],
                    ["class_name" => "fa-compass"],
                    ["class_name" => "fa-compress"],
                    ["class_name" => "fa-connectdevelop"],
                    ["class_name" => "fa-contao"],
                    ["class_name" => "fa-copy"],
                    ["class_name" => "fa-copyright"],
                    ["class_name" => "fa-creative"],
                    ["class_name" => "fa-credit"],
                    ["class_name" => "fa-credit"],
                    ["class_name" => "fa-crop"],
                    ["class_name" => "fa-crosshairs"],
                    ["class_name" => "fa-css3"],
                    ["class_name" => "fa-cube"],
                    ["class_name" => "fa-cubes"],
                    ["class_name" => "fa-cut"],
                    ["class_name" => "fa-cutlery"],
                    ["class_name" => "fa-dashboard"],
                    ["class_name" => "fa-dashcube"],
                    ["class_name" => "fa-database"],
                    ["class_name" => "fa-deaf"],
                    ["class_name" => "fa-deafness"],
                    ["class_name" => "fa-dedent"],
                    ["class_name" => "fa-delicious"],
                    ["class_name" => "fa-desktop"],
                    ["class_name" => "fa-deviantart"],
                    ["class_name" => "fa-diamond"],
                    ["class_name" => "fa-digg"],
                    ["class_name" => "fa-dollar"],
                    ["class_name" => "fa-dot"],
                    ["class_name" => "fa-download"],
                    ["class_name" => "fa-dribbble"],
                    ["class_name" => "fa-dropbox"],
                    ["class_name" => "fa-drupal"],
                    ["class_name" => "fa-edge"],
                    ["class_name" => "fa-edit"],
                    ["class_name" => "fa-eject"],
                    ["class_name" => "fa-ellipsis"],
                    ["class_name" => "fa-ellipsis"],
                    ["class_name" => "fa-empire"],
                    ["class_name" => "fa-envelope"],
                    ["class_name" => "fa-envelope"],
                    ["class_name" => "fa-envelope"],
                    ["class_name" => "fa-envira"],
                    ["class_name" => "fa-eraser"],
                    ["class_name" => "fa-eur"],
                    ["class_name" => "fa-euro"],
                    ["class_name" => "fa-exchange"],
                    ["class_name" => "fa-exclamation"],
                    ["class_name" => "fa-exclamation"],
                    ["class_name" => "fa-exclamation"],
                    ["class_name" => "fa-expand"],
                    ["class_name" => "fa-expeditedssl"],
                    ["class_name" => "fa-external"],
                    ["class_name" => "fa-external"],
                    ["class_name" => "fa-eye"],
                    ["class_name" => "fa-eye"],
                    ["class_name" => "fa-eyedropper"],
                    ["class_name" => "fa-fa"],
                    ["class_name" => "fa-facebook"],
                    ["class_name" => "fa-facebook"],
                    ["class_name" => "fa-facebook"],
                    ["class_name" => "fa-facebook"],
                    ["class_name" => "fa-fast"],
                    ["class_name" => "fa-fast"],
                    ["class_name" => "fa-fax"],
                    ["class_name" => "fa-feed"],
                    ["class_name" => "fa-female"],
                    ["class_name" => "fa-fighter"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-file"],
                    ["class_name" => "fa-files"],
                    ["class_name" => "fa-film"],
                    ["class_name" => "fa-filter"],
                    ["class_name" => "fa-fire"],
                    ["class_name" => "fa-fire"],
                    ["class_name" => "fa-firefox"],
                    ["class_name" => "fa-first"],
                    ["class_name" => "fa-flag"],
                    ["class_name" => "fa-flag"],
                    ["class_name" => "fa-flag"],
                    ["class_name" => "fa-flash"],
                    ["class_name" => "fa-flask"],
                    ["class_name" => "fa-flickr"],
                    ["class_name" => "fa-floppy"],
                    ["class_name" => "fa-folder"],
                    ["class_name" => "fa-folder"],
                    ["class_name" => "fa-folder"],
                    ["class_name" => "fa-folder"],
                    ["class_name" => "fa-font"],
                    ["class_name" => "fa-font"],
                    ["class_name" => "fa-fonticons"],
                    ["class_name" => "fa-fort"],
                    ["class_name" => "fa-forumbee"],
                    ["class_name" => "fa-forward"],
                    ["class_name" => "fa-foursquare"],
                    ["class_name" => "fa-frown"],
                    ["class_name" => "fa-futbol"],
                    ["class_name" => "fa-gamepad"],
                    ["class_name" => "fa-gavel"],
                    ["class_name" => "fa-gbp"],
                    ["class_name" => "fa-ge"],
                    ["class_name" => "fa-gear"],
                    ["class_name" => "fa-gears"],
                    ["class_name" => "fa-genderless"],
                    ["class_name" => "fa-get"],
                    ["class_name" => "fa-gg"],
                    ["class_name" => "fa-gg"],
                    ["class_name" => "fa-gift"],
                    ["class_name" => "fa-git"],
                    ["class_name" => "fa-git"],
                    ["class_name" => "fa-github"],
                    ["class_name" => "fa-github"],
                    ["class_name" => "fa-github"],
                    ["class_name" => "fa-gitlab"],
                    ["class_name" => "fa-gittip"],
                    ["class_name" => "fa-glass"],
                    ["class_name" => "fa-glide"],
                    ["class_name" => "fa-glide"],
                    ["class_name" => "fa-globe"],
                    ["class_name" => "fa-google"],
                    ["class_name" => "fa-google"],
                    ["class_name" => "fa-google"],
                    ["class_name" => "fa-google"],
                    ["class_name" => "fa-google"],
                    ["class_name" => "fa-google"],
                    ["class_name" => "fa-graduation"],
                    ["class_name" => "fa-gratipay"],
                    ["class_name" => "fa-group"],
                    ["class_name" => "fa-h"],
                    ["class_name" => "fa-hacker"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hand"],
                    ["class_name" => "fa-hard"],
                    ["class_name" => "fa-hashtag"],
                    ["class_name" => "fa-hdd"],
                    ["class_name" => "fa-header"],
                    ["class_name" => "fa-headphones"],
                    ["class_name" => "fa-heart"],
                    ["class_name" => "fa-heart"],
                    ["class_name" => "fa-heartbeat"],
                    ["class_name" => "fa-history"],
                    ["class_name" => "fa-home"],
                    ["class_name" => "fa-hospital"],
                    ["class_name" => "fa-hotel"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-hourglass"],
                    ["class_name" => "fa-houzz"],
                    ["class_name" => "fa-html5"],
                    ["class_name" => "fa-i"],
                    ["class_name" => "fa-ils"],
                    ["class_name" => "fa-image"],
                    ["class_name" => "fa-inbox"],
                    ["class_name" => "fa-indent"],
                    ["class_name" => "fa-industry"],
                    ["class_name" => "fa-info"],
                    ["class_name" => "fa-info"],
                    ["class_name" => "fa-inr"],
                    ["class_name" => "fa-instagram"],
                    ["class_name" => "fa-institution"],
                    ["class_name" => "fa-internet"],
                    ["class_name" => "fa-intersex"],
                    ["class_name" => "fa-ioxhost"],
                    ["class_name" => "fa-italic"],
                    ["class_name" => "fa-joomla"],
                    ["class_name" => "fa-jpy"],
                    ["class_name" => "fa-jsfiddle"],
                    ["class_name" => "fa-key"],
                    ["class_name" => "fa-keyboard"],
                    ["class_name" => "fa-krw"],
                    ["class_name" => "fa-language"],
                    ["class_name" => "fa-laptop"],
                    ["class_name" => "fa-lastfm"],
                    ["class_name" => "fa-lastfm"],
                    ["class_name" => "fa-leaf"],
                    ["class_name" => "fa-leanpub"],
                    ["class_name" => "fa-legal"],
                    ["class_name" => "fa-lemon"],
                    ["class_name" => "fa-level"],
                    ["class_name" => "fa-level"],
                    ["class_name" => "fa-life"],
                    ["class_name" => "fa-life"],
                    ["class_name" => "fa-life"],
                    ["class_name" => "fa-life"],
                    ["class_name" => "fa-lightbulb"],
                    ["class_name" => "fa-line"],
                    ["class_name" => "fa-link"],
                    ["class_name" => "fa-linkedin"],
                    ["class_name" => "fa-linkedin"],
                    ["class_name" => "fa-linux"],
                    ["class_name" => "fa-list"],
                    ["class_name" => "fa-list"],
                    ["class_name" => "fa-list"],
                    ["class_name" => "fa-list"],
                    ["class_name" => "fa-location"],
                    ["class_name" => "fa-lock"],
                    ["class_name" => "fa-long"],
                    ["class_name" => "fa-long"],
                    ["class_name" => "fa-long"],
                    ["class_name" => "fa-long"],
                    ["class_name" => "fa-low"],
                    ["class_name" => "fa-magic"],
                    ["class_name" => "fa-magnet"],
                    ["class_name" => "fa-mail"],
                    ["class_name" => "fa-mail"],
                    ["class_name" => "fa-mail"],
                    ["class_name" => "fa-male"],
                    ["class_name" => "fa-map"],
                    ["class_name" => "fa-map"],
                    ["class_name" => "fa-map"],
                    ["class_name" => "fa-map"],
                    ["class_name" => "fa-map"],
                    ["class_name" => "fa-mars"],
                    ["class_name" => "fa-mars"],
                    ["class_name" => "fa-mars"],
                    ["class_name" => "fa-mars"],
                    ["class_name" => "fa-mars"],
                    ["class_name" => "fa-maxcdn"],
                    ["class_name" => "fa-meanpath"],
                    ["class_name" => "fa-medium"],
                    ["class_name" => "fa-medkit"],
                    ["class_name" => "fa-meh"],
                    ["class_name" => "fa-mercury"],
                    ["class_name" => "fa-microphone"],
                    ["class_name" => "fa-microphone"],
                    ["class_name" => "fa-minus"],
                    ["class_name" => "fa-minus"],
                    ["class_name" => "fa-minus"],
                    ["class_name" => "fa-minus"],
                    ["class_name" => "fa-mixcloud"],
                    ["class_name" => "fa-mobile"],
                    ["class_name" => "fa-mobile"],
                    ["class_name" => "fa-modx"],
                    ["class_name" => "fa-money"],
                    ["class_name" => "fa-moon"],
                    ["class_name" => "fa-mortar"],
                    ["class_name" => "fa-motorcycle"],
                    ["class_name" => "fa-mouse"],
                    ["class_name" => "fa-music"],
                    ["class_name" => "fa-navicon"],
                    ["class_name" => "fa-neuter"],
                    ["class_name" => "fa-newspaper"],
                    ["class_name" => "fa-object"],
                    ["class_name" => "fa-object"],
                    ["class_name" => "fa-odnoklassniki"],
                    ["class_name" => "fa-odnoklassniki"],
                    ["class_name" => "fa-opencart"],
                    ["class_name" => "fa-openid"],
                    ["class_name" => "fa-opera"],
                    ["class_name" => "fa-optin"],
                    ["class_name" => "fa-outdent"],
                    ["class_name" => "fa-pagelines"],
                    ["class_name" => "fa-paint"],
                    ["class_name" => "fa-paper"],
                    ["class_name" => "fa-paper"],
                    ["class_name" => "fa-paperclip"],
                    ["class_name" => "fa-paragraph"],
                    ["class_name" => "fa-paste"],
                    ["class_name" => "fa-pause"],
                    ["class_name" => "fa-pause"],
                    ["class_name" => "fa-pause"],
                    ["class_name" => "fa-paw"],
                    ["class_name" => "fa-paypal"],
                    ["class_name" => "fa-pencil"],
                    ["class_name" => "fa-pencil"],
                    ["class_name" => "fa-pencil"],
                    ["class_name" => "fa-percent"],
                    ["class_name" => "fa-phone"],
                    ["class_name" => "fa-phone"],
                    ["class_name" => "fa-photo"],
                    ["class_name" => "fa-picture"],
                    ["class_name" => "fa-pie"],
                    ["class_name" => "fa-pied"],
                    ["class_name" => "fa-pied"],
                    ["class_name" => "fa-pied"],
                    ["class_name" => "fa-pinterest"],
                    ["class_name" => "fa-pinterest"],
                    ["class_name" => "fa-pinterest"],
                    ["class_name" => "fa-plane"],
                    ["class_name" => "fa-play"],
                    ["class_name" => "fa-play"],
                    ["class_name" => "fa-play"],
                    ["class_name" => "fa-plug"],
                    ["class_name" => "fa-plus"],
                    ["class_name" => "fa-plus"],
                    ["class_name" => "fa-plus"],
                    ["class_name" => "fa-plus"],
                    ["class_name" => "fa-power"],
                    ["class_name" => "fa-print"],
                    ["class_name" => "fa-product"],
                    ["class_name" => "fa-puzzle"],
                    ["class_name" => "fa-qq"],
                    ["class_name" => "fa-qrcode"],
                    ["class_name" => "fa-question"],
                    ["class_name" => "fa-question"],
                    ["class_name" => "fa-question"],
                    ["class_name" => "fa-quote"],
                    ["class_name" => "fa-quote"],
                    ["class_name" => "fa-ra"],
                    ["class_name" => "fa-random"],
                    ["class_name" => "fa-rebel"],
                    ["class_name" => "fa-recycle"],
                    ["class_name" => "fa-reddit"],
                    ["class_name" => "fa-reddit"],
                    ["class_name" => "fa-reddit"],
                    ["class_name" => "fa-refresh"],
                    ["class_name" => "fa-registered"],
                    ["class_name" => "fa-remove"],
                    ["class_name" => "fa-renren"],
                    ["class_name" => "fa-reorder"],
                    ["class_name" => "fa-repeat"],
                    ["class_name" => "fa-reply"],
                    ["class_name" => "fa-reply"],
                    ["class_name" => "fa-resistance"],
                    ["class_name" => "fa-retweet"],
                    ["class_name" => "fa-rmb"],
                    ["class_name" => "fa-road"],
                    ["class_name" => "fa-rocket"],
                    ["class_name" => "fa-rotate"],
                    ["class_name" => "fa-rotate"],
                    ["class_name" => "fa-rouble"],
                    ["class_name" => "fa-rss"],
                    ["class_name" => "fa-rss"],
                    ["class_name" => "fa-rub"],
                    ["class_name" => "fa-ruble"],
                    ["class_name" => "fa-rupee"],
                    ["class_name" => "fa-safari"],
                    ["class_name" => "fa-save"],
                    ["class_name" => "fa-scissors"],
                    ["class_name" => "fa-scribd"],
                    ["class_name" => "fa-search"],
                    ["class_name" => "fa-search"],
                    ["class_name" => "fa-search"],
                    ["class_name" => "fa-sellsy"],
                    ["class_name" => "fa-send"],
                    ["class_name" => "fa-send"],
                    ["class_name" => "fa-server"],
                    ["class_name" => "fa-share"],
                    ["class_name" => "fa-share"],
                    ["class_name" => "fa-share"],
                    ["class_name" => "fa-share"],
                    ["class_name" => "fa-share"],
                    ["class_name" => "fa-shekel"],
                    ["class_name" => "fa-sheqel"],
                    ["class_name" => "fa-shield"],
                    ["class_name" => "fa-ship"],
                    ["class_name" => "fa-shirtsinbulk"],
                    ["class_name" => "fa-shopping"],
                    ["class_name" => "fa-shopping"],
                    ["class_name" => "fa-shopping"],
                    ["class_name" => "fa-sign"],
                    ["class_name" => "fa-sign"],
                    ["class_name" => "fa-sign"],
                    ["class_name" => "fa-signal"],
                    ["class_name" => "fa-signing"],
                    ["class_name" => "fa-simplybuilt"],
                    ["class_name" => "fa-sitemap"],
                    ["class_name" => "fa-skyatlas"],
                    ["class_name" => "fa-skype"],
                    ["class_name" => "fa-slack"],
                    ["class_name" => "fa-sliders"],
                    ["class_name" => "fa-slideshare"],
                    ["class_name" => "fa-smile"],
                    ["class_name" => "fa-snapchat"],
                    ["class_name" => "fa-snapchat"],
                    ["class_name" => "fa-snapchat"],
                    ["class_name" => "fa-soccer"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-sort"],
                    ["class_name" => "fa-soundcloud"],
                    ["class_name" => "fa-space"],
                    ["class_name" => "fa-spinner"],
                    ["class_name" => "fa-spoon"],
                    ["class_name" => "fa-spotify"],
                    ["class_name" => "fa-square"],
                    ["class_name" => "fa-square"],
                    ["class_name" => "fa-stack"],
                    ["class_name" => "fa-stack"],
                    ["class_name" => "fa-star"],
                    ["class_name" => "fa-star"],
                    ["class_name" => "fa-star"],
                    ["class_name" => "fa-star"],
                    ["class_name" => "fa-star"],
                    ["class_name" => "fa-star"],
                    ["class_name" => "fa-steam"],
                    ["class_name" => "fa-steam"],
                    ["class_name" => "fa-step"],
                    ["class_name" => "fa-step"],
                    ["class_name" => "fa-stethoscope"],
                    ["class_name" => "fa-sticky"],
                    ["class_name" => "fa-sticky"],
                    ["class_name" => "fa-stop"],
                    ["class_name" => "fa-stop"],
                    ["class_name" => "fa-stop"],
                    ["class_name" => "fa-street"],
                    ["class_name" => "fa-strikethrough"],
                    ["class_name" => "fa-stumbleupon"],
                    ["class_name" => "fa-stumbleupon"],
                    ["class_name" => "fa-subscript"],
                    ["class_name" => "fa-subway"],
                    ["class_name" => "fa-suitcase"],
                    ["class_name" => "fa-sun"],
                    ["class_name" => "fa-superscript"],
                    ["class_name" => "fa-support"],
                    ["class_name" => "fa-table"],
                    ["class_name" => "fa-tablet"],
                    ["class_name" => "fa-tachometer"],
                    ["class_name" => "fa-tag"],
                    ["class_name" => "fa-tags"],
                    ["class_name" => "fa-tasks"],
                    ["class_name" => "fa-taxi"],
                    ["class_name" => "fa-television"],
                    ["class_name" => "fa-tencent"],
                    ["class_name" => "fa-terminal"],
                    ["class_name" => "fa-text"],
                    ["class_name" => "fa-text"],
                    ["class_name" => "fa-th"],
                    ["class_name" => "fa-th"],
                    ["class_name" => "fa-th"],
                    ["class_name" => "fa-themeisle"],
                    ["class_name" => "fa-thumb"],
                    ["class_name" => "fa-thumbs"],
                    ["class_name" => "fa-thumbs"],
                    ["class_name" => "fa-thumbs"],
                    ["class_name" => "fa-thumbs"],
                    ["class_name" => "fa-ticket"],
                    ["class_name" => "fa-times"],
                    ["class_name" => "fa-times"],
                    ["class_name" => "fa-times"],
                    ["class_name" => "fa-tint"],
                    ["class_name" => "fa-toggle"],
                    ["class_name" => "fa-toggle"],
                    ["class_name" => "fa-toggle"],
                    ["class_name" => "fa-toggle"],
                    ["class_name" => "fa-toggle"],
                    ["class_name" => "fa-toggle"],
                    ["class_name" => "fa-trademark"],
                    ["class_name" => "fa-train"],
                    ["class_name" => "fa-transgender"],
                    ["class_name" => "fa-transgender"],
                    ["class_name" => "fa-trash"],
                    ["class_name" => "fa-trash"],
                    ["class_name" => "fa-tree"],
                    ["class_name" => "fa-trello"],
                    ["class_name" => "fa-tripadvisor"],
                    ["class_name" => "fa-trophy"],
                    ["class_name" => "fa-truck"],
                    ["class_name" => "fa-try"],
                    ["class_name" => "fa-tty"],
                    ["class_name" => "fa-tumblr"],
                    ["class_name" => "fa-tumblr"],
                    ["class_name" => "fa-turkish"],
                    ["class_name" => "fa-tv"],
                    ["class_name" => "fa-twitch"],
                    ["class_name" => "fa-twitter"],
                    ["class_name" => "fa-twitter"],
                    ["class_name" => "fa-umbrella"],
                    ["class_name" => "fa-underline"],
                    ["class_name" => "fa-undo"],
                    ["class_name" => "fa-universal"],
                    ["class_name" => "fa-university"],
                    ["class_name" => "fa-unlink"],
                    ["class_name" => "fa-unlock"],
                    ["class_name" => "fa-unlock"],
                    ["class_name" => "fa-unsorted"],
                    ["class_name" => "fa-upload"],
                    ["class_name" => "fa-usb"],
                    ["class_name" => "fa-usd"],
                    ["class_name" => "fa-user"],
                    ["class_name" => "fa-user"],
                    ["class_name" => "fa-user"],
                    ["class_name" => "fa-user"],
                    ["class_name" => "fa-user"],
                    ["class_name" => "fa-users"],
                    ["class_name" => "fa-venus"],
                    ["class_name" => "fa-venus"],
                    ["class_name" => "fa-venus"],
                    ["class_name" => "fa-viacoin"],
                    ["class_name" => "fa-viadeo"],
                    ["class_name" => "fa-viadeo"],
                    ["class_name" => "fa-video"],
                    ["class_name" => "fa-vimeo"],
                    ["class_name" => "fa-vimeo"],
                    ["class_name" => "fa-vine"],
                    ["class_name" => "fa-vk"],
                    ["class_name" => "fa-volume"],
                    ["class_name" => "fa-volume"],
                    ["class_name" => "fa-volume"],
                    ["class_name" => "fa-volume"],
                    ["class_name" => "fa-warning"],
                    ["class_name" => "fa-wechat"],
                    ["class_name" => "fa-weibo"],
                    ["class_name" => "fa-weixin"],
                    ["class_name" => "fa-whatsapp"],
                    ["class_name" => "fa-wheelchair"],
                    ["class_name" => "fa-wheelchair"],
                    ["class_name" => "fa-wifi"],
                    ["class_name" => "fa-wikipedia"],
                    ["class_name" => "fa-windows"],
                    ["class_name" => "fa-won"],
                    ["class_name" => "fa-wordpress"],
                    ["class_name" => "fa-wpbeginner"],
                    ["class_name" => "fa-wpforms"],
                    ["class_name" => "fa-wrench"],
                    ["class_name" => "fa-xing"],
                    ["class_name" => "fa-xing"],
                    ["class_name" => "fa-y"],
                    ["class_name" => "fa-y"],
                    ["class_name" => "fa-yahoo"],
                    ["class_name" => "fa-yc"],
                    ["class_name" => "fa-yc"],
                    ["class_name" => "fa-yelp"],
                    ["class_name" => "fa-yen"],
                    ["class_name" => "fa-yoast"],
                    ["class_name" => "fa-youtube"],
                    ["class_name" => "fa-youtube"],
                    ["class_name" => "fa-youtube"],
                    ["class_name" => "fa-balance-scale"],
                    ["class_name" => "fa-battery-0"],
                    ["class_name" => "fa-battery-1"],
                    ["class_name" => "fa-battery-2"],
                    ["class_name" => "fa-battery-3"],
                    ["class_name" => "fa-battery-4"],
                    ["class_name" => "fa-battery-empty"],
                    ["class_name" => "fa-battery-full"],
                    ["class_name" => "fa-battery-half"],
                    ["class_name" => "fa-battery-quarter"],
                    ["class_name" => "fa-battery-three"],
                    ["class_name" => "fa-black-tie"],
                    ["class_name" => "fa-calendar-check"],
                    ["class_name" => "fa-calendar-minus"],
                    ["class_name" => "fa-calendar-plus"],
                    ["class_name" => "fa-calendar-times"],
                    ["class_name" => "fa-cc-diners"],
                    ["class_name" => "fa-cc-jcb"],
                    ["class_name" => "fa-commenting-o"],
                    ["class_name" => "fa-creative-commons"],
                    ["class_name" => "fa-get-pocket"],
                    ["class_name" => "fa-gg-circle"],
                    ["class_name" => "fa-hand-grab"],
                    ["class_name" => "fa-hand-lizard"],
                    ["class_name" => "fa-hand-paper"],
                    ["class_name" => "fa-hand-peace"],
                    ["class_name" => "fa-hand-pointer"],
                    ["class_name" => "fa-hand-rock"],
                    ["class_name" => "fa-hand-scissors"],
                    ["class_name" => "fa-hand-spock"],
                    ["class_name" => "fa-hand-stop"],
                    ["class_name" => "fa-hourglass-1"],
                    ["class_name" => "fa-hourglass-2"],
                    ["class_name" => "fa-hourglass-3"],
                    ["class_name" => "fa-hourglass-end"],
                    ["class_name" => "fa-hourglass-half"],
                    ["class_name" => "fa-hourglass-o"],
                    ["class_name" => "fa-hourglass-start"],
                    ["class_name" => "fa-i-cursor"],
                    ["class_name" => "fa-internet-explorer"],
                    ["class_name" => "fa-map-o"],
                    ["class_name" => "fa-map-pin"],
                    ["class_name" => "fa-map-signs"],
                    ["class_name" => "fa-mouse-pointer"],
                    ["class_name" => "fa-object-group"],
                    ["class_name" => "fa-object-ungroup"],
                    ["class_name" => "fa-odnoklassniki-square"],
                    ["class_name" => "fa-optin-monster"],
                    ["class_name" => "fa-sticky-note"],
                    ["class_name" => "fa-sticky-note"],
                    ["class_name" => "fa-wikipedia-w"],
                    ["class_name" => "fa-y-combinator"],
                    ["class_name" => "fa-area-chart"],
                    ["class_name" => "fa-arrows-h"],
                    ["class_name" => "fa-arrows-v"],
                    ["class_name" => "fa-balance-scale"],
                    ["class_name" => "fa-bar-chart"],
                    ["class_name" => "fa-bar-chart"],
                    ["class_name" => "fa-battery-0"],
                    ["class_name" => "fa-battery-1"],
                    ["class_name" => "fa-battery-2"],
                    ["class_name" => "fa-battery-3"],
                    ["class_name" => "fa-battery-4"],
                    ["class_name" => "fa-battery-empty"],
                    ["class_name" => "fa-battery-full"],
                    ["class_name" => "fa-battery-half"],
                    ["class_name" => "fa-battery-quarter"],
                    ["class_name" => "fa-battery-three"],
                    ["class_name" => "fa-bell-o"],
                    ["class_name" => "fa-bell-slash"],
                    ["class_name" => "fa-bell-slash"],
                    ["class_name" => "fa-birthday-cake"],
                    ["class_name" => "fa-bookmark-o"],
                    ["class_name" => "fa-building-o"],
                    ["class_name" => "fa-calendar-check"],
                    ["class_name" => "fa-calendar-minus"],
                    ["class_name" => "fa-calendar-o"],
                    ["class_name" => "fa-calendar-plus"],
                    ["class_name" => "fa-calendar-times"],
                    ["class_name" => "fa-camera-retro"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-cart-arrow"],
                    ["class_name" => "fa-cart-plus"],
                    ["class_name" => "fa-check-circle"],
                    ["class_name" => "fa-check-circle"],
                    ["class_name" => "fa-check-square"],
                    ["class_name" => "fa-check-square"],
                    ["class_name" => "fa-circle-o"],
                    ["class_name" => "fa-circle-o"],
                    ["class_name" => "fa-circle-thin"],
                    ["class_name" => "fa-clock-o"],
                    ["class_name" => "fa-cloud-download"],
                    ["class_name" => "fa-cloud-upload"],
                    ["class_name" => "fa-code-fork"],
                    ["class_name" => "fa-comment-o"],
                    ["class_name" => "fa-commenting-o"],
                    ["class_name" => "fa-comments-o"],
                    ["class_name" => "fa-creative-commons"],
                    ["class_name" => "fa-credit-card"],
                    ["class_name" => "fa-dot-circle"],
                    ["class_name" => "fa-ellipsis-h"],
                    ["class_name" => "fa-ellipsis-v"],
                    ["class_name" => "fa-envelope-o"],
                    ["class_name" => "fa-envelope-square"],
                    ["class_name" => "fa-exclamation-circle"],
                    ["class_name" => "fa-exclamation-triangle"],
                    ["class_name" => "fa-external-link"],
                    ["class_name" => "fa-external-link"],
                    ["class_name" => "fa-eye-slash"],
                    ["class_name" => "fa-fighter-jet"],
                    ["class_name" => "fa-file-archive"],
                    ["class_name" => "fa-file-audio"],
                    ["class_name" => "fa-file-code"],
                    ["class_name" => "fa-file-excel"],
                    ["class_name" => "fa-file-image"],
                    ["class_name" => "fa-file-movie"],
                    ["class_name" => "fa-file-pdf"],
                    ["class_name" => "fa-file-photo"],
                    ["class_name" => "fa-file-picture"],
                    ["class_name" => "fa-file-powerpoint"],
                    ["class_name" => "fa-file-sound"],
                    ["class_name" => "fa-file-video"],
                    ["class_name" => "fa-file-word"],
                    ["class_name" => "fa-file-zip"],
                    ["class_name" => "fa-fire-extinguisher"],
                    ["class_name" => "fa-flag-checkered"],
                    ["class_name" => "fa-flag-o"],
                    ["class_name" => "fa-folder-o"],
                    ["class_name" => "fa-folder-open"],
                    ["class_name" => "fa-folder-open"],
                    ["class_name" => "fa-frown-o"],
                    ["class_name" => "fa-futbol-o"],
                    ["class_name" => "fa-graduation-cap"],
                    ["class_name" => "fa-hand-grab"],
                    ["class_name" => "fa-hand-lizard"],
                    ["class_name" => "fa-hand-paper"],
                    ["class_name" => "fa-hand-peace"],
                    ["class_name" => "fa-hand-pointer"],
                    ["class_name" => "fa-hand-rock"],
                    ["class_name" => "fa-hand-scissors"],
                    ["class_name" => "fa-hand-spock"],
                    ["class_name" => "fa-hand-stop"],
                    ["class_name" => "fa-hdd-o"],
                    ["class_name" => "fa-heart-o"],
                    ["class_name" => "fa-hourglass-1"],
                    ["class_name" => "fa-hourglass-2"],
                    ["class_name" => "fa-hourglass-3"],
                    ["class_name" => "fa-hourglass-end"],
                    ["class_name" => "fa-hourglass-half"],
                    ["class_name" => "fa-hourglass-o"],
                    ["class_name" => "fa-hourglass-start"],
                    ["class_name" => "fa-i-cursor"],
                    ["class_name" => "fa-info-circle"],
                    ["class_name" => "fa-keyboard-o"],
                    ["class_name" => "fa-lemon-o"],
                    ["class_name" => "fa-level-down"],
                    ["class_name" => "fa-level-up"],
                    ["class_name" => "fa-life-bouy"],
                    ["class_name" => "fa-life-buoy"],
                    ["class_name" => "fa-life-ring"],
                    ["class_name" => "fa-life-saver"],
                    ["class_name" => "fa-lightbulb-o"],
                    ["class_name" => "fa-line-chart"],
                    ["class_name" => "fa-location-arrow"],
                    ["class_name" => "fa-mail-forward"],
                    ["class_name" => "fa-mail-reply"],
                    ["class_name" => "fa-mail-reply"],
                    ["class_name" => "fa-map-marker"],
                    ["class_name" => "fa-map-o"],
                    ["class_name" => "fa-map-pin"],
                    ["class_name" => "fa-map-signs"],
                    ["class_name" => "fa-meh-o"],
                    ["class_name" => "fa-microphone-slash"],
                    ["class_name" => "fa-minus-circle"],
                    ["class_name" => "fa-minus-square"],
                    ["class_name" => "fa-minus-square"],
                    ["class_name" => "fa-mobile-phone"],
                    ["class_name" => "fa-moon-o"],
                    ["class_name" => "fa-mortar-board"],
                    ["class_name" => "fa-mouse-pointer"],
                    ["class_name" => "fa-newspaper-o"],
                    ["class_name" => "fa-object-group"],
                    ["class_name" => "fa-object-ungroup"],
                    ["class_name" => "fa-paint-brush"],
                    ["class_name" => "fa-paper-plane"],
                    ["class_name" => "fa-paper-plane"],
                    ["class_name" => "fa-pencil-square"],
                    ["class_name" => "fa-pencil-square"],
                    ["class_name" => "fa-phone-square"],
                    ["class_name" => "fa-picture-o"],
                    ["class_name" => "fa-pie-chart"],
                    ["class_name" => "fa-plus-circle"],
                    ["class_name" => "fa-plus-square"],
                    ["class_name" => "fa-plus-square"],
                    ["class_name" => "fa-power-off"],
                    ["class_name" => "fa-puzzle-piece"],
                    ["class_name" => "fa-question-circle"],
                    ["class_name" => "fa-quote-left"],
                    ["class_name" => "fa-quote-right"],
                    ["class_name" => "fa-reply-all"],
                    ["class_name" => "fa-rss-square"],
                    ["class_name" => "fa-search-minus"],
                    ["class_name" => "fa-search-plus"],
                    ["class_name" => "fa-send-o"],
                    ["class_name" => "fa-share-alt"],
                    ["class_name" => "fa-share-alt"],
                    ["class_name" => "fa-share-square"],
                    ["class_name" => "fa-share-square"],
                    ["class_name" => "fa-shopping-cart"],
                    ["class_name" => "fa-sign-in"],
                    ["class_name" => "fa-sign-out"],
                    ["class_name" => "fa-smile-o"],
                    ["class_name" => "fa-soccer-ball"],
                    ["class_name" => "fa-sort-alpha"],
                    ["class_name" => "fa-sort-alpha"],
                    ["class_name" => "fa-sort-amount"],
                    ["class_name" => "fa-sort-amount"],
                    ["class_name" => "fa-sort-asc"],
                    ["class_name" => "fa-sort-desc"],
                    ["class_name" => "fa-sort-down"],
                    ["class_name" => "fa-sort-numeric"],
                    ["class_name" => "fa-sort-numeric"],
                    ["class_name" => "fa-sort-up"],
                    ["class_name" => "fa-space-shuttle"],
                    ["class_name" => "fa-square-o"],
                    ["class_name" => "fa-star-half"],
                    ["class_name" => "fa-star-half"],
                    ["class_name" => "fa-star-half"],
                    ["class_name" => "fa-star-half"],
                    ["class_name" => "fa-star-o"],
                    ["class_name" => "fa-sticky-note"],
                    ["class_name" => "fa-sticky-note"],
                    ["class_name" => "fa-street-view"],
                    ["class_name" => "fa-sun-o"],
                    ["class_name" => "fa-thumb-tack"],
                    ["class_name" => "fa-thumbs-down"],
                    ["class_name" => "fa-thumbs-o"],
                    ["class_name" => "fa-thumbs-o"],
                    ["class_name" => "fa-thumbs-up"],
                    ["class_name" => "fa-times-circle"],
                    ["class_name" => "fa-times-circle"],
                    ["class_name" => "fa-toggle-down"],
                    ["class_name" => "fa-toggle-left"],
                    ["class_name" => "fa-toggle-off"],
                    ["class_name" => "fa-toggle-on"],
                    ["class_name" => "fa-toggle-right"],
                    ["class_name" => "fa-toggle-up"],
                    ["class_name" => "fa-trash-o"],
                    ["class_name" => "fa-unlock-alt"],
                    ["class_name" => "fa-user-plus"],
                    ["class_name" => "fa-user-secret"],
                    ["class_name" => "fa-user-times"],
                    ["class_name" => "fa-video-camera"],
                    ["class_name" => "fa-volume-down"],
                    ["class_name" => "fa-volume-off"],
                    ["class_name" => "fa-volume-up"],
                    ["class_name" => "fa-hand-grab"],
                    ["class_name" => "fa-hand-lizard"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-hand-paper"],
                    ["class_name" => "fa-hand-peace"],
                    ["class_name" => "fa-hand-pointer"],
                    ["class_name" => "fa-hand-rock"],
                    ["class_name" => "fa-hand-scissors"],
                    ["class_name" => "fa-hand-spock"],
                    ["class_name" => "fa-hand-stop"],
                    ["class_name" => "fa-thumbs-down"],
                    ["class_name" => "fa-thumbs-o"],
                    ["class_name" => "fa-thumbs-o"],
                    ["class_name" => "fa-thumbs-up"],
                    ["class_name" => "fa-fighter-jet"],
                    ["class_name" => "fa-space-shuttle"],
                    ["class_name" => "fa-mars-double"],
                    ["class_name" => "fa-mars-stroke"],
                    ["class_name" => "fa-mars-stroke"],
                    ["class_name" => "fa-mars-stroke"],
                    ["class_name" => "fa-transgender-alt"],
                    ["class_name" => "fa-venus-double"],
                    ["class_name" => "fa-venus-mars"],
                    ["class_name" => "fa-file-archive"],
                    ["class_name" => "fa-file-audio"],
                    ["class_name" => "fa-file-code"],
                    ["class_name" => "fa-file-excel"],
                    ["class_name" => "fa-file-image"],
                    ["class_name" => "fa-file-movie"],
                    ["class_name" => "fa-file-o"],
                    ["class_name" => "fa-file-pdf"],
                    ["class_name" => "fa-file-photo"],
                    ["class_name" => "fa-file-picture"],
                    ["class_name" => "fa-file-powerpoint"],
                    ["class_name" => "fa-file-sound"],
                    ["class_name" => "fa-file-text"],
                    ["class_name" => "fa-file-text"],
                    ["class_name" => "fa-file-video"],
                    ["class_name" => "fa-file-word"],
                    ["class_name" => "fa-file-zip"],
                    ["class_name" => "fa-circle-o"],
                    ["class_name" => "fa-check-square"],
                    ["class_name" => "fa-check-square"],
                    ["class_name" => "fa-circle-o"],
                    ["class_name" => "fa-dot-circle"],
                    ["class_name" => "fa-minus-square"],
                    ["class_name" => "fa-minus-square"],
                    ["class_name" => "fa-plus-square"],
                    ["class_name" => "fa-plus-square"],
                    ["class_name" => "fa-square-o"],
                    ["class_name" => "fa-cc-amex"],
                    ["class_name" => "fa-cc-diners"],
                    ["class_name" => "fa-cc-discover"],
                    ["class_name" => "fa-cc-jcb"],
                    ["class_name" => "fa-cc-mastercard"],
                    ["class_name" => "fa-cc-paypal"],
                    ["class_name" => "fa-cc-stripe"],
                    ["class_name" => "fa-cc-visa"],
                    ["class_name" => "fa-credit-card"],
                    ["class_name" => "fa-google-wallet"],
                    ["class_name" => "fa-area-chart"],
                    ["class_name" => "fa-bar-chart"],
                    ["class_name" => "fa-bar-chart"],
                    ["class_name" => "fa-line-chart"],
                    ["class_name" => "fa-pie-chart"],
                    ["class_name" => "fa-gg-circle"],
                    ["class_name" => "fa-turkish-lira"],
                    ["class_name" => "fa-align-center"],
                    ["class_name" => "fa-align-justify"],
                    ["class_name" => "fa-align-left"],
                    ["class_name" => "fa-align-right"],
                    ["class_name" => "fa-chain-broken"],
                    ["class_name" => "fa-file-o"],
                    ["class_name" => "fa-file-text"],
                    ["class_name" => "fa-file-text"],
                    ["class_name" => "fa-files-o"],
                    ["class_name" => "fa-floppy-o"],
                    ["class_name" => "fa-list-alt"],
                    ["class_name" => "fa-list-ol"],
                    ["class_name" => "fa-list-ul"],
                    ["class_name" => "fa-rotate-left"],
                    ["class_name" => "fa-rotate-right"],
                    ["class_name" => "fa-text-height"],
                    ["class_name" => "fa-text-width"],
                    ["class_name" => "fa-th-large"],
                    ["class_name" => "fa-th-list"],
                    ["class_name" => "fa-angle-double"],
                    ["class_name" => "fa-angle-double"],
                    ["class_name" => "fa-angle-double"],
                    ["class_name" => "fa-angle-double"],
                    ["class_name" => "fa-angle-down"],
                    ["class_name" => "fa-angle-left"],
                    ["class_name" => "fa-angle-right"],
                    ["class_name" => "fa-angle-up"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-down"],
                    ["class_name" => "fa-arrow-left"],
                    ["class_name" => "fa-arrow-right"],
                    ["class_name" => "fa-arrow-up"],
                    ["class_name" => "fa-arrows-alt"],
                    ["class_name" => "fa-arrows-h"],
                    ["class_name" => "fa-arrows-v"],
                    ["class_name" => "fa-caret-down"],
                    ["class_name" => "fa-caret-left"],
                    ["class_name" => "fa-caret-right"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-caret-up"],
                    ["class_name" => "fa-chevron-circle"],
                    ["class_name" => "fa-chevron-circle"],
                    ["class_name" => "fa-chevron-circle"],
                    ["class_name" => "fa-chevron-circle"],
                    ["class_name" => "fa-chevron-down"],
                    ["class_name" => "fa-chevron-left"],
                    ["class_name" => "fa-chevron-right"],
                    ["class_name" => "fa-chevron-up"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-long-arrow"],
                    ["class_name" => "fa-long-arrow"],
                    ["class_name" => "fa-long-arrow"],
                    ["class_name" => "fa-long-arrow"],
                    ["class_name" => "fa-toggle-down"],
                    ["class_name" => "fa-toggle-left"],
                    ["class_name" => "fa-toggle-right"],
                    ["class_name" => "fa-toggle-up"],
                    ["class_name" => "fa-arrows-alt"],
                    ["class_name" => "fa-fast-backward"],
                    ["class_name" => "fa-fast-forward"],
                    ["class_name" => "fa-play-circle"],
                    ["class_name" => "fa-play-circle"],
                    ["class_name" => "fa-step-backward"],
                    ["class_name" => "fa-step-forward"],
                    ["class_name" => "fa-youtube-play"],
                    ["class_name" => "fa-behance-square"],
                    ["class_name" => "fa-bitbucket-square"],
                    ["class_name" => "fa-black-tie"],
                    ["class_name" => "fa-cc-amex"],
                    ["class_name" => "fa-cc-diners"],
                    ["class_name" => "fa-cc-discover"],
                    ["class_name" => "fa-cc-jcb"],
                    ["class_name" => "fa-cc-mastercard"],
                    ["class_name" => "fa-cc-paypal"],
                    ["class_name" => "fa-cc-stripe"],
                    ["class_name" => "fa-cc-visa"],
                    ["class_name" => "fa-facebook-f"],
                    ["class_name" => "fa-facebook-official"],
                    ["class_name" => "fa-facebook-square"],
                    ["class_name" => "fa-get-pocket"],
                    ["class_name" => "fa-gg-circle"],
                    ["class_name" => "fa-git-square"],
                    ["class_name" => "fa-github-alt"],
                    ["class_name" => "fa-github-square"],
                    ["class_name" => "fa-google-plus"],
                    ["class_name" => "fa-google-plus"],
                    ["class_name" => "fa-google-wallet"],
                    ["class_name" => "fa-hacker-news"],
                    ["class_name" => "fa-internet-explorer"],
                    ["class_name" => "fa-lastfm-square"],
                    ["class_name" => "fa-linkedin-square"],
                    ["class_name" => "fa-odnoklassniki-square"],
                    ["class_name" => "fa-optin-monster"],
                    ["class_name" => "fa-pied-piper"],
                    ["class_name" => "fa-pied-piper"],
                    ["class_name" => "fa-pinterest-p"],
                    ["class_name" => "fa-pinterest-square"],
                    ["class_name" => "fa-reddit-square"],
                    ["class_name" => "fa-share-alt"],
                    ["class_name" => "fa-share-alt"],
                    ["class_name" => "fa-stack-exchange"],
                    ["class_name" => "fa-stack-overflow"],
                    ["class_name" => "fa-steam-square"],
                    ["class_name" => "fa-stumbleupon-circle"],
                    ["class_name" => "fa-tencent-weibo"],
                    ["class_name" => "fa-tumblr-square"],
                    ["class_name" => "fa-twitter-square"],
                    ["class_name" => "fa-vimeo-square"],
                    ["class_name" => "fa-wikipedia-w"],
                    ["class_name" => "fa-xing-square"],
                    ["class_name" => "fa-y-combinator"],
                    ["class_name" => "fa-y-combinator"],
                    ["class_name" => "fa-yc-square"],
                    ["class_name" => "fa-youtube-play"],
                    ["class_name" => "fa-youtube-square"],
                    ["class_name" => "fa-h-square"],
                    ["class_name" => "fa-heart-o"],
                    ["class_name" => "fa-hospital-o"],
                    ["class_name" => "fa-plus-square"],
                    ["class_name" => "fa-user-md"],
                    ["class_name" => "fa-balance-scale"],
                    ["class_name" => "fa-battery-0"],
                    ["class_name" => "fa-battery-1"],
                    ["class_name" => "fa-battery-2"],
                    ["class_name" => "fa-battery-3"],
                    ["class_name" => "fa-battery-4"],
                    ["class_name" => "fa-battery-empty"],
                    ["class_name" => "fa-battery-full"],
                    ["class_name" => "fa-battery-half"],
                    ["class_name" => "fa-battery-quarter"],
                    ["class_name" => "fa-battery-three"],
                    ["class_name" => "fa-black-tie"],
                    ["class_name" => "fa-calendar-check"],
                    ["class_name" => "fa-calendar-minus"],
                    ["class_name" => "fa-calendar-plus"],
                    ["class_name" => "fa-calendar-times"],
                    ["class_name" => "fa-cc-diners"],
                    ["class_name" => "fa-cc-jcb"],
                    ["class_name" => "fa-commenting-o"],
                    ["class_name" => "fa-creative-commons"],
                    ["class_name" => "fa-get-pocket"],
                    ["class_name" => "fa-gg-circle"],
                    ["class_name" => "fa-hand-grab"],
                    ["class_name" => "fa-hand-lizard"],
                    ["class_name" => "fa-hand-paper"],
                    ["class_name" => "fa-hand-peace"],
                    ["class_name" => "fa-hand-pointer"],
                    ["class_name" => "fa-hand-rock"],
                    ["class_name" => "fa-hand-scissors"],
                    ["class_name" => "fa-hand-spock"],
                    ["class_name" => "fa-hand-stop"],
                    ["class_name" => "fa-hourglass-1"],
                    ["class_name" => "fa-hourglass-2"],
                    ["class_name" => "fa-hourglass-3"],
                    ["class_name" => "fa-hourglass-end"],
                    ["class_name" => "fa-hourglass-half"],
                    ["class_name" => "fa-hourglass-o"],
                    ["class_name" => "fa-hourglass-start"],
                    ["class_name" => "fa-i-cursor"],
                    ["class_name" => "fa-internet-explorer"],
                    ["class_name" => "fa-map-o"],
                    ["class_name" => "fa-map-pin"],
                    ["class_name" => "fa-map-signs"],
                    ["class_name" => "fa-mouse-pointer"],
                    ["class_name" => "fa-object-group"],
                    ["class_name" => "fa-object-ungroup"],
                    ["class_name" => "fa-odnoklassniki-square"],
                    ["class_name" => "fa-optin-monster"],
                    ["class_name" => "fa-sticky-note"],
                    ["class_name" => "fa-sticky-note"],
                    ["class_name" => "fa-wikipedia-w"],
                    ["class_name" => "fa-y-combinator"],
                    ["class_name" => "fa-area-chart"],
                    ["class_name" => "fa-arrows-h"],
                    ["class_name" => "fa-arrows-v"],
                    ["class_name" => "fa-balance-scale"],
                    ["class_name" => "fa-bar-chart"],
                    ["class_name" => "fa-bar-chart"],
                    ["class_name" => "fa-battery-0"],
                    ["class_name" => "fa-battery-1"],
                    ["class_name" => "fa-battery-2"],
                    ["class_name" => "fa-battery-3"],
                    ["class_name" => "fa-battery-4"],
                    ["class_name" => "fa-battery-empty"],
                    ["class_name" => "fa-battery-full"],
                    ["class_name" => "fa-battery-half"],
                    ["class_name" => "fa-battery-quarter"],
                    ["class_name" => "fa-battery-three"],
                    ["class_name" => "fa-bell-o"],
                    ["class_name" => "fa-bell-slash"],
                    ["class_name" => "fa-bell-slash"],
                    ["class_name" => "fa-birthday-cake"],
                    ["class_name" => "fa-bookmark-o"],
                    ["class_name" => "fa-building-o"],
                    ["class_name" => "fa-calendar-check"],
                    ["class_name" => "fa-calendar-minus"],
                    ["class_name" => "fa-calendar-o"],
                    ["class_name" => "fa-calendar-plus"],
                    ["class_name" => "fa-calendar-times"],
                    ["class_name" => "fa-camera-retro"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-cart-arrow"],
                    ["class_name" => "fa-cart-plus"],
                    ["class_name" => "fa-check-circle"],
                    ["class_name" => "fa-check-circle"],
                    ["class_name" => "fa-check-square"],
                    ["class_name" => "fa-check-square"],
                    ["class_name" => "fa-circle-o"],
                    ["class_name" => "fa-circle-o"],
                    ["class_name" => "fa-circle-thin"],
                    ["class_name" => "fa-clock-o"],
                    ["class_name" => "fa-cloud-download"],
                    ["class_name" => "fa-cloud-upload"],
                    ["class_name" => "fa-code-fork"],
                    ["class_name" => "fa-comment-o"],
                    ["class_name" => "fa-commenting-o"],
                    ["class_name" => "fa-comments-o"],
                    ["class_name" => "fa-creative-commons"],
                    ["class_name" => "fa-credit-card"],
                    ["class_name" => "fa-dot-circle"],
                    ["class_name" => "fa-ellipsis-h"],
                    ["class_name" => "fa-ellipsis-v"],
                    ["class_name" => "fa-envelope-o"],
                    ["class_name" => "fa-envelope-square"],
                    ["class_name" => "fa-exclamation-circle"],
                    ["class_name" => "fa-exclamation-triangle"],
                    ["class_name" => "fa-external-link"],
                    ["class_name" => "fa-external-link"],
                    ["class_name" => "fa-eye-slash"],
                    ["class_name" => "fa-fighter-jet"],
                    ["class_name" => "fa-file-archive"],
                    ["class_name" => "fa-file-audio"],
                    ["class_name" => "fa-file-code"],
                    ["class_name" => "fa-file-excel"],
                    ["class_name" => "fa-file-image"],
                    ["class_name" => "fa-file-movie"],
                    ["class_name" => "fa-file-pdf"],
                    ["class_name" => "fa-file-photo"],
                    ["class_name" => "fa-file-picture"],
                    ["class_name" => "fa-file-powerpoint"],
                    ["class_name" => "fa-file-sound"],
                    ["class_name" => "fa-file-video"],
                    ["class_name" => "fa-file-word"],
                    ["class_name" => "fa-file-zip"],
                    ["class_name" => "fa-fire-extinguisher"],
                    ["class_name" => "fa-flag-checkered"],
                    ["class_name" => "fa-flag-o"],
                    ["class_name" => "fa-folder-o"],
                    ["class_name" => "fa-folder-open"],
                    ["class_name" => "fa-folder-open"],
                    ["class_name" => "fa-frown-o"],
                    ["class_name" => "fa-futbol-o"],
                    ["class_name" => "fa-graduation-cap"],
                    ["class_name" => "fa-hand-grab"],
                    ["class_name" => "fa-hand-lizard"],
                    ["class_name" => "fa-hand-paper"],
                    ["class_name" => "fa-hand-peace"],
                    ["class_name" => "fa-hand-pointer"],
                    ["class_name" => "fa-hand-rock"],
                    ["class_name" => "fa-hand-scissors"],
                    ["class_name" => "fa-hand-spock"],
                    ["class_name" => "fa-hand-stop"],
                    ["class_name" => "fa-hdd-o"],
                    ["class_name" => "fa-heart-o"],
                    ["class_name" => "fa-hourglass-1"],
                    ["class_name" => "fa-hourglass-2"],
                    ["class_name" => "fa-hourglass-3"],
                    ["class_name" => "fa-hourglass-end"],
                    ["class_name" => "fa-hourglass-half"],
                    ["class_name" => "fa-hourglass-o"],
                    ["class_name" => "fa-hourglass-start"],
                    ["class_name" => "fa-i-cursor"],
                    ["class_name" => "fa-info-circle"],
                    ["class_name" => "fa-keyboard-o"],
                    ["class_name" => "fa-lemon-o"],
                    ["class_name" => "fa-level-down"],
                    ["class_name" => "fa-level-up"],
                    ["class_name" => "fa-life-bouy"],
                    ["class_name" => "fa-life-buoy"],
                    ["class_name" => "fa-life-ring"],
                    ["class_name" => "fa-life-saver"],
                    ["class_name" => "fa-lightbulb-o"],
                    ["class_name" => "fa-line-chart"],
                    ["class_name" => "fa-location-arrow"],
                    ["class_name" => "fa-mail-forward"],
                    ["class_name" => "fa-mail-reply"],
                    ["class_name" => "fa-mail-reply"],
                    ["class_name" => "fa-map-marker"],
                    ["class_name" => "fa-map-o"],
                    ["class_name" => "fa-map-pin"],
                    ["class_name" => "fa-map-signs"],
                    ["class_name" => "fa-meh-o"],
                    ["class_name" => "fa-microphone-slash"],
                    ["class_name" => "fa-minus-circle"],
                    ["class_name" => "fa-minus-square"],
                    ["class_name" => "fa-minus-square"],
                    ["class_name" => "fa-mobile-phone"],
                    ["class_name" => "fa-moon-o"],
                    ["class_name" => "fa-mortar-board"],
                    ["class_name" => "fa-mouse-pointer"],
                    ["class_name" => "fa-newspaper-o"],
                    ["class_name" => "fa-object-group"],
                    ["class_name" => "fa-object-ungroup"],
                    ["class_name" => "fa-paint-brush"],
                    ["class_name" => "fa-paper-plane"],
                    ["class_name" => "fa-paper-plane"],
                    ["class_name" => "fa-pencil-square"],
                    ["class_name" => "fa-pencil-square"],
                    ["class_name" => "fa-phone-square"],
                    ["class_name" => "fa-picture-o"],
                    ["class_name" => "fa-pie-chart"],
                    ["class_name" => "fa-plus-circle"],
                    ["class_name" => "fa-plus-square"],
                    ["class_name" => "fa-plus-square"],
                    ["class_name" => "fa-power-off"],
                    ["class_name" => "fa-puzzle-piece"],
                    ["class_name" => "fa-question-circle"],
                    ["class_name" => "fa-quote-left"],
                    ["class_name" => "fa-quote-right"],
                    ["class_name" => "fa-reply-all"],
                    ["class_name" => "fa-rss-square"],
                    ["class_name" => "fa-search-minus"],
                    ["class_name" => "fa-search-plus"],
                    ["class_name" => "fa-send-o"],
                    ["class_name" => "fa-share-alt"],
                    ["class_name" => "fa-share-alt"],
                    ["class_name" => "fa-share-square"],
                    ["class_name" => "fa-share-square"],
                    ["class_name" => "fa-shopping-cart"],
                    ["class_name" => "fa-sign-in"],
                    ["class_name" => "fa-sign-out"],
                    ["class_name" => "fa-smile-o"],
                    ["class_name" => "fa-soccer-ball"],
                    ["class_name" => "fa-sort-alpha"],
                    ["class_name" => "fa-sort-alpha"],
                    ["class_name" => "fa-sort-amount"],
                    ["class_name" => "fa-sort-amount"],
                    ["class_name" => "fa-sort-asc"],
                    ["class_name" => "fa-sort-desc"],
                    ["class_name" => "fa-sort-down"],
                    ["class_name" => "fa-sort-numeric"],
                    ["class_name" => "fa-sort-numeric"],
                    ["class_name" => "fa-sort-up"],
                    ["class_name" => "fa-space-shuttle"],
                    ["class_name" => "fa-square-o"],
                    ["class_name" => "fa-star-half"],
                    ["class_name" => "fa-star-half"],
                    ["class_name" => "fa-star-half"],
                    ["class_name" => "fa-star-half"],
                    ["class_name" => "fa-star-o"],
                    ["class_name" => "fa-sticky-note"],
                    ["class_name" => "fa-sticky-note"],
                    ["class_name" => "fa-street-view"],
                    ["class_name" => "fa-sun-o"],
                    ["class_name" => "fa-thumb-tack"],
                    ["class_name" => "fa-thumbs-down"],
                    ["class_name" => "fa-thumbs-o"],
                    ["class_name" => "fa-thumbs-o"],
                    ["class_name" => "fa-thumbs-up"],
                    ["class_name" => "fa-times-circle"],
                    ["class_name" => "fa-times-circle"],
                    ["class_name" => "fa-toggle-down"],
                    ["class_name" => "fa-toggle-left"],
                    ["class_name" => "fa-toggle-off"],
                    ["class_name" => "fa-toggle-on"],
                    ["class_name" => "fa-toggle-right"],
                    ["class_name" => "fa-toggle-up"],
                    ["class_name" => "fa-trash-o"],
                    ["class_name" => "fa-unlock-alt"],
                    ["class_name" => "fa-user-plus"],
                    ["class_name" => "fa-user-secret"],
                    ["class_name" => "fa-user-times"],
                    ["class_name" => "fa-video-camera"],
                    ["class_name" => "fa-volume-down"],
                    ["class_name" => "fa-volume-off"],
                    ["class_name" => "fa-volume-up"],
                    ["class_name" => "fa-hand-grab"],
                    ["class_name" => "fa-hand-lizard"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-hand-paper"],
                    ["class_name" => "fa-hand-peace"],
                    ["class_name" => "fa-hand-pointer"],
                    ["class_name" => "fa-hand-rock"],
                    ["class_name" => "fa-hand-scissors"],
                    ["class_name" => "fa-hand-spock"],
                    ["class_name" => "fa-hand-stop"],
                    ["class_name" => "fa-thumbs-down"],
                    ["class_name" => "fa-thumbs-o"],
                    ["class_name" => "fa-thumbs-o"],
                    ["class_name" => "fa-thumbs-up"],
                    ["class_name" => "fa-fighter-jet"],
                    ["class_name" => "fa-space-shuttle"],
                    ["class_name" => "fa-mars-double"],
                    ["class_name" => "fa-mars-stroke"],
                    ["class_name" => "fa-mars-stroke"],
                    ["class_name" => "fa-mars-stroke"],
                    ["class_name" => "fa-transgender-alt"],
                    ["class_name" => "fa-venus-double"],
                    ["class_name" => "fa-venus-mars"],
                    ["class_name" => "fa-file-archive"],
                    ["class_name" => "fa-file-audio"],
                    ["class_name" => "fa-file-code"],
                    ["class_name" => "fa-file-excel"],
                    ["class_name" => "fa-file-image"],
                    ["class_name" => "fa-file-movie"],
                    ["class_name" => "fa-file-o"],
                    ["class_name" => "fa-file-pdf"],
                    ["class_name" => "fa-file-photo"],
                    ["class_name" => "fa-file-picture"],
                    ["class_name" => "fa-file-powerpoint"],
                    ["class_name" => "fa-file-sound"],
                    ["class_name" => "fa-file-text"],
                    ["class_name" => "fa-file-text"],
                    ["class_name" => "fa-file-video"],
                    ["class_name" => "fa-file-word"],
                    ["class_name" => "fa-file-zip"],
                    ["class_name" => "fa-circle-o"],
                    ["class_name" => "fa-check-square"],
                    ["class_name" => "fa-check-square"],
                    ["class_name" => "fa-circle-o"],
                    ["class_name" => "fa-dot-circle"],
                    ["class_name" => "fa-minus-square"],
                    ["class_name" => "fa-minus-square"],
                    ["class_name" => "fa-plus-square"],
                    ["class_name" => "fa-plus-square"],
                    ["class_name" => "fa-square-o"],
                    ["class_name" => "fa-cc-amex"],
                    ["class_name" => "fa-cc-diners"],
                    ["class_name" => "fa-cc-discover"],
                    ["class_name" => "fa-cc-jcb"],
                    ["class_name" => "fa-cc-mastercard"],
                    ["class_name" => "fa-cc-paypal"],
                    ["class_name" => "fa-cc-stripe"],
                    ["class_name" => "fa-cc-visa"],
                    ["class_name" => "fa-credit-card"],
                    ["class_name" => "fa-google-wallet"],
                    ["class_name" => "fa-area-chart"],
                    ["class_name" => "fa-bar-chart"],
                    ["class_name" => "fa-bar-chart"],
                    ["class_name" => "fa-line-chart"],
                    ["class_name" => "fa-pie-chart"],
                    ["class_name" => "fa-gg-circle"],
                    ["class_name" => "fa-turkish-lira"],
                    ["class_name" => "fa-align-center"],
                    ["class_name" => "fa-align-justify"],
                    ["class_name" => "fa-align-left"],
                    ["class_name" => "fa-align-right"],
                    ["class_name" => "fa-chain-broken"],
                    ["class_name" => "fa-file-o"],
                    ["class_name" => "fa-file-text"],
                    ["class_name" => "fa-file-text"],
                    ["class_name" => "fa-files-o"],
                    ["class_name" => "fa-floppy-o"],
                    ["class_name" => "fa-list-alt"],
                    ["class_name" => "fa-list-ol"],
                    ["class_name" => "fa-list-ul"],
                    ["class_name" => "fa-rotate-left"],
                    ["class_name" => "fa-rotate-right"],
                    ["class_name" => "fa-text-height"],
                    ["class_name" => "fa-text-width"],
                    ["class_name" => "fa-th-large"],
                    ["class_name" => "fa-th-list"],
                    ["class_name" => "fa-angle-double"],
                    ["class_name" => "fa-angle-double"],
                    ["class_name" => "fa-angle-double"],
                    ["class_name" => "fa-angle-double"],
                    ["class_name" => "fa-angle-down"],
                    ["class_name" => "fa-angle-left"],
                    ["class_name" => "fa-angle-right"],
                    ["class_name" => "fa-angle-up"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-circle"],
                    ["class_name" => "fa-arrow-down"],
                    ["class_name" => "fa-arrow-left"],
                    ["class_name" => "fa-arrow-right"],
                    ["class_name" => "fa-arrow-up"],
                    ["class_name" => "fa-arrows-alt"],
                    ["class_name" => "fa-arrows-h"],
                    ["class_name" => "fa-arrows-v"],
                    ["class_name" => "fa-caret-down"],
                    ["class_name" => "fa-caret-left"],
                    ["class_name" => "fa-caret-right"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-caret-square"],
                    ["class_name" => "fa-caret-up"],
                    ["class_name" => "fa-chevron-circle"],
                    ["class_name" => "fa-chevron-circle"],
                    ["class_name" => "fa-chevron-circle"],
                    ["class_name" => "fa-chevron-circle"],
                    ["class_name" => "fa-chevron-down"],
                    ["class_name" => "fa-chevron-left"],
                    ["class_name" => "fa-chevron-right"],
                    ["class_name" => "fa-chevron-up"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-hand-o"],
                    ["class_name" => "fa-long-arrow"],
                    ["class_name" => "fa-long-arrow"],
                    ["class_name" => "fa-long-arrow"],
                    ["class_name" => "fa-long-arrow"],
                    ["class_name" => "fa-toggle-down"],
                    ["class_name" => "fa-toggle-left"],
                    ["class_name" => "fa-toggle-right"],
                    ["class_name" => "fa-toggle-up"],
                    ["class_name" => "fa-arrows-alt"],
                    ["class_name" => "fa-fast-backward"],
                    ["class_name" => "fa-fast-forward"],
                    ["class_name" => "fa-play-circle"],
                    ["class_name" => "fa-play-circle"],
                    ["class_name" => "fa-step-backward"],
                    ["class_name" => "fa-step-forward"],
                    ["class_name" => "fa-youtube-play"],
                    ["class_name" => "fa-behance-square"],
                    ["class_name" => "fa-bitbucket-square"],
                    ["class_name" => "fa-black-tie"],
                    ["class_name" => "fa-cc-amex"],
                    ["class_name" => "fa-cc-diners"],
                    ["class_name" => "fa-cc-discover"],
                    ["class_name" => "fa-cc-jcb"],
                    ["class_name" => "fa-cc-mastercard"],
                    ["class_name" => "fa-cc-paypal"],
                    ["class_name" => "fa-cc-stripe"],
                    ["class_name" => "fa-cc-visa"],
                    ["class_name" => "fa-facebook-f"],
                    ["class_name" => "fa-facebook-official"],
                    ["class_name" => "fa-facebook-square"],
                    ["class_name" => "fa-get-pocket"],
                    ["class_name" => "fa-gg-circle"],
                    ["class_name" => "fa-git-square"],
                    ["class_name" => "fa-github-alt"],
                    ["class_name" => "fa-github-square"],
                    ["class_name" => "fa-google-plus"],
                    ["class_name" => "fa-google-plus"],
                    ["class_name" => "fa-google-wallet"],
                    ["class_name" => "fa-hacker-news"],
                    ["class_name" => "fa-internet-explorer"],
                    ["class_name" => "fa-lastfm-square"],
                    ["class_name" => "fa-linkedin-square"],
                    ["class_name" => "fa-odnoklassniki-square"],
                    ["class_name" => "fa-optin-monster"],
                    ["class_name" => "fa-pied-piper"],
                    ["class_name" => "fa-pied-piper"],
                    ["class_name" => "fa-pinterest-p"],
                    ["class_name" => "fa-pinterest-square"],
                    ["class_name" => "fa-reddit-square"],
                    ["class_name" => "fa-share-alt"],
                    ["class_name" => "fa-share-alt"],
                    ["class_name" => "fa-stack-exchange"],
                    ["class_name" => "fa-stack-overflow"],
                    ["class_name" => "fa-steam-square"],
                    ["class_name" => "fa-stumbleupon-circle"],
                    ["class_name" => "fa-tencent-weibo"],
                    ["class_name" => "fa-tumblr-square"],
                    ["class_name" => "fa-twitter-square"],
                    ["class_name" => "fa-vimeo-square"],
                    ["class_name" => "fa-wikipedia-w"],
                    ["class_name" => "fa-xing-square"],
                    ["class_name" => "fa-y-combinator"],
                    ["class_name" => "fa-y-combinator"],
                    ["class_name" => "fa-yc-square"],
                    ["class_name" => "fa-youtube-play"],
                    ["class_name" => "fa-youtube-square"],
                    ["class_name" => "fa-h-square"],
                    ["class_name" => "fa-heart-o"],
                    ["class_name" => "fa-hospital-o"],
                    ["class_name" => "fa-plus-square"],
                    ["class_name" => "fa-user-md"],

                ]);

        }

        public function down()
        {
            $tables = $this->db->query('SHOW TABLES FROM '.$this->db->database)->result(); 
            foreach ($tables as $table) {
                $tab = array_values((array)$table)[0];
                $this->dbforge->drop_table($tab);
            }   
        }
}